/***************************************************************************
 *
 * $Header: /home/werner/ytree/RCS/system.c,v 1.8 1997/08/13 12:24:58 werner Rel $
 *
 * System Call
 *
 ***************************************************************************/


#include "ytree.h"




int SystemCall(char *command_line)
{
  int result;

  endwin();
  result = SilentSystemCall( command_line );
  
  (void) GetAvailBytes( &statistic.disk_space );

  return( result );
}


int QuerySystemCall(char *command_line)
{
  int result;

  endwin();
  result = SilentSystemCall( command_line );
  HitReturnToContinue();
  (void) GetAvailBytes( &statistic.disk_space );

  return( result );
}



extern struct itimerval value, ovalue;

int SilentSystemCall(char *command_line)
{
  int result;

#ifdef CLOCK_SUPPORT
  struct itimerval value, ovalue;
#endif


  /* Hier ist die einzige Stelle, in der Kommandos aufgerufen werden! */

#if defined( __NeXT__ )
  nl();
#endif /* linux */

#ifdef CLOCK_SUPPORT
  value.it_interval.tv_sec = 0;
  value.it_value.tv_sec = 0;
  value.it_interval.tv_usec = 0;
  setitimer(ITIMER_REAL, &value, &ovalue);
  signal(SIGALRM, SIG_IGN);
#endif

  result = system( command_line );

#ifdef CLOCK_SUPPORT
  setitimer(ITIMER_REAL, &ovalue, &value);
  signal(SIGALRM, ClockHandler);
#endif

  leaveok(stdscr, TRUE);
#if defined( __NeXT__ )
  cbreak();
  nonl();
  noecho();
  clearok( stdscr, TRUE );
#endif /* linux */ 
  
  return( result ); 
}


