/***************************************************************************
 *
 * $Header: /home/werner/ytree/RCS/disp.c,v 1.12 1998/07/26 21:21:13 werner Rel $
 *
 * Menue-Geruest anzeigen
 *
 ***************************************************************************/


#include "ytree.h"
#include "patchlev.h"


static void PrintMenuLine(WINDOW *win, int y, int x, char *line);
static void PrintLine(WINDOW *win, int y, int x, char *line, int len);
static void DisplayVersion(void);



static char *mask[] = {
"5--------------------2",
"|FILE:               |",
"6--------------------7",
"|DISK:               |",
"| Available          |",
"|  Bytes:            |",
"6--------------------7",
"|DISK Statistics     |",
"| [Total]              |",
"|  Files:            |",
"|  Bytes:            |",
"| [Matching]           |",
"|  Files:            |",
"|  Bytes:            |",
"| [Tagged]             |",
"|  Files:            |",
"|  Bytes:            |",
"| [Current Directory]  |",
"|                    |",
"|  Bytes:            |"
};


static char *logo[] = {
                        "                  #                       ",
                        "                ##                        ",
                        "     ##  ##   #####  ## ###   ####    ####",
                        "    ##  ##    ##     ##  ## ##  ##  ##  ##",
                        "   ##  ##    ##     ##  ## ######  ###### ",
                        "   #####    ## #   ##     ##      ##      ",
                        "     ##     ###  ####     ####    ####    ",
                        "#####                                     "
		      };

static char *extended_line = "| |                    |";


static char *last_line = "3-8--------------------4";
static char *first_line ="1-5";


static char *dir_help[MAX_MODES][2] = 
  {
    { /* DISK_MODE */
      "DIR       (A)ttribute (D)elete  (F)ilespec  (G)roup (L)og (M)akedir (Q)uit                ",
      "COMMANDS  (O)wner (R)ename (S)howall (T)ag (U)ntag e(X)ecute   (^F) dirmode               "
    },
    { /* LL_FILE_MODE */
      "DIR       (F)ilespec (L)ogin (S)howall (T)ag (U)ntag e(X)ecute   (^F) dirmode  (Q)uit       ",
      "COMMANDS                                                                    "
    },
    { /* TAR_FILE_MODE */
      "TAR-DIR   (F)ilespec (L)og (S)howall (T)ag (U)ntag e(X)ecute   (^F) dirmode  (Q)uit         ",
      "COMMANDS                                                                    "
    },
    { /* ZOO_FILE_MODE */
      "ZOO-DIR   (F)ilespec (L)og (S)howall (T)ag (U)ntag e(X)ecute   (^F) dirmode  (Q)uit         ",
      "COMMANDS                                                                    "
    },
    { /* ZIP_FILE_MODE */
      "ZIP-DIR   (F)ilespec (L)og (S)howall (T)ag (U)ntag e(X)ecute   (^F) dirmode  (Q)uit         ",
      "COMMANDS                                                                    "
    },
    { /* LHA_FILE_MODE */
      "LHA-DIR   (F)ilespec (L)og (S)howall (T)ag (U)ntag e(X)ecute   (^F) dirmode  (Q)uit         ",
      "COMMANDS                                                                    "
    },
    { /* ARC_FILE_MODE */
      "ARC-DIR   (F)ilespec (L)og (S)howall (T)ag (U)ntag e(X)ecute   (^F) dirmode  (Q)uit         ",
      "COMMANDS                                                                    "
    },
    { /* RPM_FILE_MODE */
      "RPM-DIR   (F)ilespec (L)og (S)howall (T)ag (U)ntag e(X)ecute   (^F) dirmode  (Q)uit         ",
      "COMMANDS                                                                    "
    },
    { /* TAPE_MODE */
      "TAPE-DIR  (F)ilespec (L)og (S)howall (T)ag (U)ntag e(X)ecute   (^F) dirmode  (Q)uit         ",
      "COMMANDS                                                                    "
    }
  };


static char *file_help[MAX_MODES][2] = 
  {
    { /* DISK_MODE */
      "FILE      (A)ttribute (C)opy (D)elete (E)dit (F)ilespec (G)roup (H)ex (L)ogin (M)ove    (Q)uit ",
      "COMMANDS  (O)wner (P)ipe (R)ename (S)ort (T)ag (U)ntag (V)iew e(X)ecute pathcop(Y) (^F)ilemode "
    },
    { /* LL_FILE_MODE */
      "FILE      (F)ilespec (L)ogin (S)ort (T)ag (U)ntag e(X)ecute (^F)ilemode      (Q)uit        ",
      "COMMANDS                                                                   "
    },
    { /* TAR_FILE_MODE */
      "TAR-FILE  (C)opy (F)ilespec (H)ex (P)ipe (S)ort (T)ag (U)ntag (V)iew pathcop(Y) (Q)uit         ",
      "COMMANDS  (^F)ilemode                                                        "
    },
    { /* ZOO_FILE_MODE */
      "ZOO-FILE  (C)opy (F)ilespec (H)ex (P)ipe (S)ort (T)ag (U)ntag (V)iew pathcop(Y) (Q)uit         ",
      "COMMANDS  (^F)ilemode                                                        "
    },
    { /* ZIP_FILE_MODE */
      "ZIP-FILE  (C)opy (F)ilespec (H)ex (P)ipe (S)ort (T)ag (U)ntag (V)iew pathcop(Y) (Q)uit         ",
      "COMMANDS  (^F)ilemode                                                        "
    },
    { /* LHA_FILE_MODE */
      "LHA-FILE  (C)opy (F)ilespec (H)ex (P)ipe (S)ort (T)ag (U)ntag (V)iew pathcop(Y) (Q)uit         ",
      "COMMANDS  (^F)ilemode                                                        "
    },
    { /* ARC_FILE_MODE */
      "ARC-FILE  (C)opy (F)ilespec (H)ex (P)ipe (S)ort (T)ag (U)ntag (V)iew pathcop(Y) (Q)uit         ",
      "COMMANDS  (^F)ilemode                                                        "
    },
    { /* RPM_FILE_MODE */
      "RPM-FILE  (C)opy (F)ilespec (H)ex (P)ipe (S)ort (T)ag (U)ntag (V)iew pathcop(Y) (Q)uit         ",
      "COMMANDS  (^F)ilemode                                                        "
    },
    { /* TAPE_MODE */
      "TAPE-FILE (C)opy (F)ilespec (H)ex (P)ipe (S)ort (T)ag (U)ntag (V)iew pathcop(Y) (Q)uit         ",
      "COMMANDS  (^F)ilemode                                                        "
    }
  };





static void DisplayVersion(void)
{
  static char version[80];
  
  ClearHelp();
  (void) sprintf( version, 
		  "ytree Version %sPL%d %s (WB)", 
		  VERSION, 
		  PATCHLEVEL, 
		  VERSIONDATE 
		);
  MvAddStr( LINES - 2, (unsigned) (COLS - strlen( version )) >> 1, version );
}
   
   


void DisplayDirHelp(void)
{
  int i;

  for( i=0; i < sizeof(dir_help[mode]) / sizeof(dir_help[mode][0]); i++)
    PrintOptions( stdscr, LINES - 2 + i, 0, dir_help[mode][i] );
}
   


void DisplayFileHelp(void)
{
  int i;

  for( i=0; i < sizeof(file_help[mode]) / sizeof(file_help[mode][0]); i++)
    PrintOptions( stdscr, LINES - 2 + i, 0, file_help[mode][i] );
}
   


void ClearHelp(void)
{
  int i;

  for( i=0; i < 2; i++ )
  {
    wmove( stdscr, LINES - 2 + i, 0 ); clrtoeol();
  }
}
   


void DisplayMenu(void)
{
  int    y;
  int    lines, columns;
  
  
  PrintSpecialString( stdscr, 0, 0, "Path: ", MENU_COLOR );
#ifdef COLOR_SUPPORT
  clrtoeol();
#endif

  werase( dir_window );
  werase( big_file_window );
  werase( small_file_window );

  for( y=1; y <= sizeof(mask) / sizeof(mask[0]); y++){
    PrintOptions( stdscr, y, 0, "|");
    PrintOptions( stdscr, y, COLS - 22 , mask[y-1] );
  }
  for( ; y < LINES - 3; y++ )
    PrintMenuLine( stdscr, y, 0, extended_line );
  PrintLine( stdscr, DIR_WINDOW_HEIGHT + 2, 0, "6-7", COLS - 22 );
  PrintLine( stdscr, 1, 0, first_line, COLS - 22);    
  PrintMenuLine( stdscr, y, 0, last_line );

  lines = sizeof(logo) / sizeof(logo[0]);
  columns = strlen( logo[0] );

  for( y=0; y < lines; y++ )
  {
    MvWAddStr( dir_window, 
	       y + ((DIR_WINDOW_HEIGHT - lines) >> 1), 
	       (DIR_WINDOW_WIDTH - columns) >> 1,
	       logo[y]
	     );
  }
  DisplayVersion();

  touchwin( dir_window );
  /* refresh(); */
}



void SwitchToSmallFileWindow(void)
{ 
  werase( file_window );
  PrintLine( stdscr, DIR_WINDOW_HEIGHT + 2, 0, "6-7", COLS - 22 );
  file_window = small_file_window;
  wnoutrefresh( stdscr );
}


void SwitchToBigFileWindow(void)
{
  werase( file_window );
  wnoutrefresh( file_window );
#ifdef COLOR_SUPPORT
  mvaddch(DIR_WINDOW_Y + DIR_WINDOW_HEIGHT, DIR_WINDOW_X - 1, 
        ACS_VLINE | COLOR_PAIR(MENU_COLOR)| A_BOLD);
  mvaddch(DIR_WINDOW_Y + DIR_WINDOW_HEIGHT, DIR_WINDOW_X + DIR_WINDOW_WIDTH, 
           ACS_VLINE | COLOR_PAIR(MENU_COLOR)| A_BOLD);

#else
  mvwaddch( stdscr, DIR_WINDOW_Y + DIR_WINDOW_HEIGHT,  
	   DIR_WINDOW_X - 1, 
	   ACS_VLINE
	 );
  mvwaddch( stdscr, DIR_WINDOW_Y + DIR_WINDOW_HEIGHT, 
	   DIR_WINDOW_X + DIR_WINDOW_WIDTH,
	   ACS_VLINE
	 );
#endif /* COLOR_SUPPORT */
  file_window = big_file_window;
  wnoutrefresh( stdscr );
}


void MapF2Window(void)
{ 
  char *buffer;

  if( ( buffer = (char *)malloc( F2_WINDOW_WIDTH + 1 ) ) == NULL )
  {
     ERROR_MSG( "Malloc failed*ABORT" );
     exit( 1 );
  }
  werase( f2_window );
  memset(buffer, '=', F2_WINDOW_WIDTH);
  buffer[F2_WINDOW_WIDTH] = '\0';

  PrintSpecialString( f2_window, F2_WINDOW_HEIGHT - 1, 0, buffer, HST_COLOR );
  wnoutrefresh( f2_window );
  free(buffer);
}


void UnmapF2Window(void)
{ 
  werase( f2_window );
  if(file_window == big_file_window) 
  {
#ifdef COLOR_SUPPORT
  mvaddch(DIR_WINDOW_Y + DIR_WINDOW_HEIGHT, DIR_WINDOW_X - 1,
          ACS_VLINE | COLOR_PAIR(MENU_COLOR)| A_BOLD);
  mvaddch(DIR_WINDOW_Y + DIR_WINDOW_HEIGHT, DIR_WINDOW_X + DIR_WINDOW_WIDTH,
          ACS_VLINE | COLOR_PAIR(MENU_COLOR)| A_BOLD);

#else
    mvwaddch( stdscr, DIR_WINDOW_Y + DIR_WINDOW_HEIGHT,  
	     DIR_WINDOW_X - 1, 
	     ACS_VLINE
	   );

    mvwaddch( stdscr, DIR_WINDOW_Y + DIR_WINDOW_HEIGHT, 
	     DIR_WINDOW_X + DIR_WINDOW_WIDTH,
	     ACS_VLINE
	   );
#endif /* COLOR_SUPPORT */
  }
  touchwin(stdscr);
}



static void PrintMenuLine(WINDOW *win, int y, int x, char *line)
{
  int  i;
  int p;
  char *buffer;
  if (strchr(line,'('))
     p = 2;
  else
     p = 0;
  if( ( buffer = (char *)malloc( COLS + 2 + p ) ) == NULL )
  {
     ERROR_MSG( "Malloc failed*ABORT" );
     exit( 1 );
  }
  buffer[0] = line[0];
  if (p == 0)
     p = COLS - 22;
  else
     p = COLS - 24;
  for(i=1; i < (p); i++)
      buffer[i] = line[1];
  (void) strcpy( &buffer[i], &line[2] );
  PrintOptions( stdscr, y, x , buffer );
  free( buffer );
}



static void PrintLine(WINDOW *win, int y, int x, char *line, int len)
{
  int  i;
  char *buffer;
  if( ( buffer = (char *)malloc( len + 2 ) ) == NULL )
  {
     ERROR_MSG( "Malloc failed*ABORT" );
     exit( 1 );
  }
  buffer[0] = line[0];
  for(i=1; i < (len); i++)
      buffer[i] = line[1];
  (void) strcpy( &buffer[i], &line[2] );
  PrintOptions( stdscr, y, x , buffer );
  free( buffer );
}

