;;; tc-setup.el --- setup and/or loading routines for T-Code

;; Copyright (C) 1997 KITAJIMA Akira.

;; Author: KITAJIMA Akira <kitajima@ics.es.osaka-u.ac.jp>
;; Created: 26 Apr 1997
;; Version: $Id: tc-setup.el,v 2.0.8.0 2000/03/04 05:52:22 akira Exp $

;; This program is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2 of the License, or
;; (at your option) any later version.
;;
;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.
;;
;; You should have received a copy of the GNU General Public License
;; along with this program; if not, write to the Free Software
;; Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.

;;; Code:

(require 'tc-sysdep)

(defvar tcode-load-immediate nil
  "nil ǤʤȤT-Code ѤΤ٤ƤΥ⥸塼٤˥ɤ롣")

(defvar tcode-init-file-name "~/.tc"
  "tc-setup.el ɤ߽ФȤɤޤĿե̾
ե̾ѹ tc-setup.el ɤ߽Фˤͤ
ꤷʤФʤʤ")

(if (featurep 'tc-setup)
    ()
  ;; map tcode-mode to `C-\'
  (if (or (tcode-nemacs-p)
	  (tcode-mule-1-p)
	  (tcode-mule-2-p)
	  (and (tcode-xemacs-p)
	       (< emacs-major-version 21)
	       (< emacs-minor-version 3)))
      (global-set-key "\C-\\" 'toggle-input-method)
    ;; Mule 3.* Ѥ
    (or (equal current-language-environment "Japanese")
	(set-language-environment "Japanese"))
    (register-input-method "japanese-TUT-Code"
			   "Japanese"
			   'tcode-use-package
			   "TUT"
			   "a kanji direct input method")
    (register-input-method "japanese-T-Code"
			   "Japanese"
			   'tcode-use-package
			   "TC"
			   "a kanji direct input method")
    (setq-default default-input-method "japanese-T-Code")
    (setq default-input-method "japanese-T-Code"))
  ;; isearch
  (load (cond ((tcode-nemacs-p)
	       "tc-is18")
	      ((or (tcode-mule-1-p)
		   (tcode-mule-2-p)
		   (tcode-mule-3-p)
		   (and (tcode-xemacs-p) (< emacs-major-version 21)) )
	       "tc-is19")
	      ((and (tcode-xemacs-p) (>= emacs-major-version 21))
	       "tc-is19")
	      (t
	       "tc-is20")))
  ;; minibuffer
  (add-hook 'minibuffer-exit-hook 'tcode-exit-minibuffer)
  (defun tcode-exit-minibuffer ())	; dummy function
  ;; load configuration file
  (load tcode-init-file-name t)
  (if (not tcode-load-immediate)
      (progn
	(autoload 'tcode-activate "tc")
	(autoload 'tcode-load-table "tc" nil t)
	;; functions in tc-help.el
	(autoload 'tcode-display-stroke-for-char "tc-help" nil t)
	(autoload 'tcode-query-stroke "tc-help" nil t)
	(autoload 'tcode-show-tables "tc-help" nil t)
	(autoload 'tcode-mode-help "tc-help" nil t)
	(autoload 'tcode-display-direct-stroke "tc-help")
	;; functions in tc-bushu.el
	(autoload 'tcode-bushu-init "tc-bushu" nil t)
	(autoload 'tcode-bushu-henkan "tc-bushu" nil t)
	(autoload 'tcode-bushu-another-henkan "tc-bushu" nil t)
	(autoload 'tcode-lookup-outset "tc-bushu" nil t)
	;; functions in tc-mazegaki.el
	(mapcar (function (lambda (command)
			    (autoload command "tc-mazegaki" nil t)))
		'(tcode-mazegaki-switch-to-dictionary
		  tcode-mazegaki-start
		  tcode-mazegaki-toroku
		  tcode-mazegaki-toroku-and-kakutei
		  tcode-mazegaki-delete-kanji
		  tcode-mazegaki-ikkatu-toroku-region
		  tcode-mazegaki-ikkatu-toroku-buffer
		  tcode-mazegaki-ikkatu-delete-region
		  tcode-mazegaki-ikkatu-delete-buffer
		  tcode-mazegaki-delete-by-last-yomi
		  tcode-mazegaki-complete
		  tcode-mazegaki-complete-and-henkan
		  tcode-start-fixed-mazegaki
		  tcode-mazegaki-henkan))
	;; functions in tc-util.el
	(autoload 'set-tcode-mode-key "tc-util" nil t)
	(and (not (tcode-nemacs-p))
	     window-system
	     (autoload 'tcode-enable-cursor-to-change-color "tc-util" nil t))
	(autoload 'tcode-mazegaki-delete-kanji-from-dictionary "tc-util" nil t)
	(autoload 'tcode-mazegaki-get-yomi-max "tc-util" nil t)
	(autoload 'tcode-electric-space "tc-util" nil t)
	(autoload 'tcode-electric-comma "tc-util" nil t)
	(autoload 'tcode-insert-ya-outset "tc-util" nil t)
	(autoload 'tcode-transpose-strokes-or-chars "tc-util" nil t)
	(autoload 'tcode-mazegaki-show-yomi-region "tc-util" nil t)
	(autoload 'tcode-katakana-previous-char "tc-util" nil t)
	(autoload 'tcode-insert-kanji-by-kuten-code "tc-util" nil t)
	(autoload 'tcode-insert-kanji-by-jis-code "tc-util" nil t)
	(autoload 'tcode-katakana-preceding-chars "tc-util" nil t))
    ;; load all modules for T-Code
    (require 'tc-bushu)			; tc.el will be loaded also.
    (require 'tc-help)
    (require 'tc-util)
    (require 'tc-mazegaki))
  (autoload 'eelll "eelll" nil t))

(provide 'tc-setup)

;;; tc-setup.el ends here
