/*
 * Copyright (c) 2000 Dave Jones <dave@powertweak.com>
 *
 * Can be freely distributed and used under the terms of the GNU GPL.
 */

static void QuitApp (gpointer callback_data, guint callback_action, GtkWidget *widget)
{
	gtk_main_quit();
}
		

static void ShowMenu(gpointer callback_data, guint callback_action, GtkWidget *widget)
{
	g_message ("ItemFactory: activated \"%s\", action %d",
		gtk_item_factory_path_from_widget (widget), (int) callback_action);
}


GtkWidget *CreateMenus (GtkWidget *window)
{
	GtkAccelGroup *accel_group;
	GtkItemFactory *item_factory;

	static GtkItemFactoryEntry menu_items[]= {
			{"/_File",			NULL,			0,			0,	"<Branch>" },
			{"/File/tearoff1",	NULL,			ShowMenu,	0,	"<Tearoff>" },
			{"/File/E_xit",		"<control>Q",	QuitApp,	0,	0 },

			{"/_Help",			NULL,			0,			0,	"<Branch>" },
			{"/Help/_About",	NULL,			show_about,	0,	0 },
	};

	static int nmenu_items = sizeof (menu_items) / sizeof (menu_items[0]);

	accel_group = gtk_accel_group_new();
	item_factory = gtk_item_factory_new (GTK_TYPE_MENU_BAR, "<blah>", accel_group);
	gtk_item_factory_create_items (item_factory, nmenu_items, menu_items, NULL);
	gtk_accel_group_attach (accel_group, GTK_OBJECT (window));
	return (gtk_item_factory_get_widget(item_factory, "<blah>"));
}
