/*
 * Hardware tuning for the Intel 8243x PCI bridges.
 * This covers..
 *	82437FX TSC [Triton I]
 *	82439HX TXC [Triton II]
 */

#include "8243x.h"
#define Intel_8243x_TWEAKSIZE sizeof(Intel_8243x_Tweaks)/sizeof(Tweaks_t)-1

unsigned int getnumtweaks_Intel_8243x(struct pci_dev *current_dev)
{
	return Intel_8243x_TWEAKSIZE;
}

void init_Intel_8243x(struct pci_dev *current_dev)
{
	init_tweaks(Intel_8243x_TWEAKSIZE, Intel_8243x_Tweaks, current_dev);
}

void tune_Intel_8243x(GtkWidget *table, struct pci_dev *current_dev, unsigned int numbuttons)
{
	Tweaks_t *Tweaks;

	unsigned int index;
	int column=0;

	Tweaks = Intel_8243x_Tweaks;

	for (index=0;index<numbuttons;index++) {
		CreateButton(table, Tweaks, current_dev, column);
		column++;
		Tweaks++;
	}
}

void save_Intel_8243x(FILE *savehandle, struct pci_dev *current_dev)
{
	write_tweaks(savehandle, Intel_8243x_TWEAKSIZE, Intel_8243x_Tweaks, current_dev);
}
