/*
    libparted - a library for manipulating disk partitions
    Copyright (C) 1998-2000  Andrew Clausen, Lennert Buytenhek and Red Hat Inc.

	Andrew Clausen			<clausen@gnu.org>
	Lennert Buytenhek		<buytenh@gnu.org>
	Matt Wilson, Red Hat Inc.	<msw@redhat.com>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "config.h"

#include <parted/parted.h>
#include <sys/types.h>
#include <pwd.h>
#include <unistd.h>
#include <grp.h>
#include <stdlib.h>

#include <libintl.h>
#if ENABLE_NLS
#  define _(String) gettext (String)
#else
#  define _(String) (String)
#endif /* ENABLE_NLS */

static void
init_disk_types ()
{
	ped_disk_msdos_init ();
}

static void init_file_system_types ()
{
	ped_file_system_linux_swap_init ();
	ped_file_system_ext2_init ();
	ped_file_system_fat_init ();
}

int
ped_init ()
{
	if (getlogin())
		initgroups (getlogin(), 0);

	init_disk_types ();
	init_file_system_types ();

	ped_device_probe_all ();
	return 1;
}

static void
done_disk_types ()
{
	ped_disk_msdos_done ();
}

static void done_file_system_types ()
{
	ped_file_system_fat_done ();
	ped_file_system_ext2_done ();
	ped_file_system_linux_swap_done ();
}

void
ped_done ()
{
	ped_device_free_all ();

	done_disk_types ();
	done_file_system_types ();
}

void*
ped_malloc (int size)
{
	void*		mem;

	mem = (void*) malloc (size);
	if (!mem) {
		ped_exception_throw (PED_EXCEPTION_FATAL, PED_EXCEPTION_CANCEL,
				     _("Out of memory."));
		return NULL;
	}
	memset (mem, 0xff, size);	/* assist debugging */
	return mem;
}

void
ped_free (void* ptr)
{
	free (ptr);
}
