/****************************************************************************/
/* ##   ##         #####   #####  ##     **       NoSQL RDBMS - crypt8      */
/* ###  ##        ####### ####### ##     **        $Revision: 2.1 $			*/
/* #### ##        ###     ##   ## ##     ************************************/
/* #######  ####  #####   ##   ## ##     **      Carlo Strozzi (c) 1998     */
/* ####### ######   ##### ## # ## ##     ************************************/
/* ## #### ##  ##     ### ##  ### ##     **           Written by            */
/* ##  ### ###### ####### ######  ###### **          Carlo Strozzi          */
/* ##   ##  ####   #####   #### # ###### **     e-mail: carlos@linux.it     */
/****************************************************************************/
/*  NoSQL RDBMS, Copyright (C) 1998 Carlo Strozzi.                          */
/*  This program comes with ABSOLUTELY NO WARRANTY; for details             */
/*  refer to the GNU General Public License.                                */
/****************************************************************************

   Takes an eight-byte key, followed by a newline, followed by a two-byte
   salt and an ending newline from STDIN, and writes the encrypted equivalent
   to STDOUT, in the usual 13-byte format. 

   Usage example:  echo -e "ABcdeFgh\n2X" | crypt8

   Result on STDOUT: 2XSIySnuuCSoo

****************************************************************************/

#include <errno.h>
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#ifdef HAVE_CRYPT_H
#include <crypt.h>
#endif

static void error(void);

int main(void)
{
  int len;
  char *r, key[10], salt[4];
    
  fgets( key,  sizeof(key),  stdin ); 
  r=key; while(*r != '\n' && r < key+sizeof(key)) r++;
  *r='\0';

  fgets( salt, sizeof(salt), stdin );
  r=salt; while(*r != '\n' && r < salt+sizeof(salt)) r++;
  *r='\0';

  len = strlen( r = crypt( key, salt ) );
  if ( write( STDOUT_FILENO, r, len ) != len ) error();
  exit(0);
}

static void error()
{
  (void)fprintf( stderr, "nosql crypt8: %s\n", strerror( errno ) );
  exit(1);
}

