/*----------------------------------------------------------------------------*

	LinuxInfo 
		by Alex Buell	
			September 1998

 ----------------------------------------------------------------------------- 
	
	Modelled on Vince Weaver's Linux_logo 2.10
	
	Prints out a line of information about your system.
	Supports Linux on Intel, Sparc, Alpha, m68k and others.	

 ----------------------------------------------------------------------------- 

	HISTORY

	1.0.0 - Initial development using the sysinfo code from Linux_logo
	1.0.2 - Renamed from sysinfo to linuxinfo to avoid infrigement. 
	1.0.5 - Added new MHz field. Cool! :o)
	1.0.6 - 06/03/1998 - Added a new option to make testing easier
		Give it a filename as an argument and it will attept to 
		process it. 

 -----------------------------------------------------------------------------*/

#include "linuxinfo.h"

/* exported to all modules */
FILE *cpuinfo_file;

int main(int argc, char *argv[])
{
	char ordinals[10][10] = { "", "One", "Two", "Three", "Four", "Five", "Six", "Seven", "Eight", "Nine" };

	struct os_stat os;
	struct hw_stat hw;
	struct lib_stat lib;

	if (argc > 1)
		cpuinfo_file = fopen(argv[1], "r");
	else
		cpuinfo_file = fopen(CPUINFO_FILE, "r");

	if (cpuinfo_file == NULL)
		cpuinfo_file = fopen(CPUINFO_FILE, "r"); 

	GetOperatingSystemInfo(&os);
	GetHardwareInfo(&hw);
	GetSystemLibcInfo(&lib);

	printf("%s %s %s %s\n", os.os_name, os.os_hostname, os.os_version, os.os_revision); 
	printf("%s %s %sMHz processor%s, %s total bogomips, %sM RAM\n", ordinals[hw.hw_processors], \
		hw.hw_cpuinfo, hw.hw_megahertz, (hw.hw_processors > 1) ? "s" : "", hw.hw_bogomips, hw.hw_memory);
	printf("System library %s\n", lib.lib_version);

	fclose(cpuinfo_file);
	return 0;
}
