/*
 * Copyright:
 *	(C) 1998 Craig Knudsen, cknudsen@radix.net
 *	See accompanying file "COPYING".
 * 
 *	This program is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public License
 *	as published by the Free Software Foundation; either version 2
 *	of the License, or (at your option) any later version.
 * 
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 * 
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the
 *	Free Software Foundation, Inc., 59 Temple Place,
 *	Suite 330, Boston, MA  02111-1307, USA
 *
 * Description:
 *	X utilities that I cannot find a way to implement using GTK.
 *	(Maybe they'll appear in a future GTK release.)
 *
 * History:
 *	07-Apr-98	Added call to XSetIOErrorHandler.
 *	28-Mar-98	Created
 *
 ****************************************************************************/



#include <stdio.h>
#include <stdlib.h>
#include <X11/Xlib.h>


extern void save_all ();


/*
** Handle X errors.
*/
static int x_error_handler ( display, event )
Display *display;
XErrorEvent *event;
{
  fprintf ( stderr, "Received X error.  See ya!\n" );
  save_all ();
  exit ( 0 );
}

/*
** Handle X IO errors.  This could be from xkill or the window manager
** dying and closing X, etc.
*/
static int x_io_error_handler ( display )
Display *display;
{
  fprintf ( stderr, "Received X error.  See ya!\n" );
  save_all ();
  exit ( 0 );
}



/*
** Tell X to use the above function for X errors so we can catch
** them before we exit.
*/
void set_x_error_handler ()
{
  XSetErrorHandler ( x_error_handler );
  XSetIOErrorHandler ( x_io_error_handler );
}

