#include <kapp.h>
#include "accwidget.h"
#include "top-level.h"

static KApplication *a;
static AccWidget *aw;
static int ui_is_running = 0;
static int ui_is_initialized = 0;
static int ui_is_terminating = 0;

/***********************************************************************/

int gnucash_ui_init(void)
{
  int fake_argc = 1;
  char *fake_argv[] = {"gnucash"};

  if (! ui_is_initialized) {
    a = new KApplication(fake_argc, fake_argv, "GnuCash");  
    aw = new AccWidget();
    a->setMainWidget(aw);
    ui_is_initialized = 1;
  }
  return(0);  
}

int gnc_ui_main(void)
{
  gnucash_ui_init();
  gnc_refresh_main_window();
  ui_is_running = 1;

  a->exec();

  ui_is_running = 0;
  return 0;
}

int gnucash_ui_is_running(void)
{
  return(ui_is_running);
}

int gnucash_ui_is_terminating(void)
{
  return(ui_is_terminating);
}

void gnc_ui_shutdown(void *widget, void *data)
{
  ui_is_terminating = 1;
  printf("%s called\n", __FUNCTION__);
  kapp->quit();
}

void gnc_ui_destroy(void)
{
  printf("%s called\n", __FUNCTION__);
  ui_is_terminating = 0;
}

void gnc_ui_destroy_all_subwindows(void)
{
  xaccGroupWindowDestroy(gncGetCurrentGroup());
}

void gnc_refresh_main_window(void)
{
  xaccRecomputeGroupBalance(gncGetCurrentGroup());
#if 0
  gnc_ui_refresh_statusbar();
#endif
  aw->refresh();
}

/******************************* E N D *********************************/
