/******************************************************************************\
 gnofin/file.h   $Revision: 1.6 $
 Copyright (C) 1999 Darin Fisher
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
\******************************************************************************/

#ifndef FIN_FILE_H
#define FIN_FILE_H

#include <glib.h>
#include "account.h"

/* each of these functions return NULL on success, otherwise
 * they return a descriptive error message (it references a
 * static buffer, so the return value should NOT be free'd) */

const gchar * fin_file_read   (const gchar      * filename,
			       FinAccountSet   ** accounts);

const gchar * fin_file_write  (const gchar      * filename,
			       FinAccountSet    * accounts);

gint          fin_file_exists (const gchar      * path);
gint          fin_file_backup (const gchar      * path);

#endif
