/******************************************************************************\
 gnofin/exp-latex.c   $Revision: 1.2 $
 Copyright (C) 1999 Darin Fisher

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
\******************************************************************************/

#include "gnofin.h"
#include <string.h>
#include "account.h"
#include "record.h"
#include "exp-latex.h"

static FinRecordField fields[] = 
{
  FIN_RECORD_FIELD_DATE,
  FIN_RECORD_FIELD_TYPE_FULL,
  FIN_RECORD_FIELD_INFO,
  FIN_RECORD_FIELD_STATUS,
  FIN_RECORD_FIELD_AMOUNT,
  FIN_RECORD_FIELD_BALANCE,
};

static void
write_info (FILE * file, gchar * info_text)
{
  gchar reqesc[] = "&#${}"; /* characters requiring escape prefix '\' in latex 
  			     * probably there are other characters that I have
			     * forgotten, but these will have to do for now */
  gchar * c;

  fin_trace("");

  /* latex filter.. necessary to translate, for example, "&" to "\&" */

  for (c = info_text; *c; ++c)
  {
    if (strchr(reqesc, *c) != NULL)
      fprintf(file, "\\%c", *c);
    else
      fprintf(file, "%c", *c);
  }
}

static gboolean 
latex_export (FILE * file, const gchar * filename, FinAccountSet * set)
{
  GList * ac, *rc;

  fin_trace("");

  /* at some point, it would be cool to surface a lot of the latex
   * style settings.. especially the font style.. and of course the 
   * paper type.. for now i am just going to go with US Letter */

  fprintf(file, "\\documentclass[letterpaper,10pt]{article}\n\n"
  		"\\setlength{\\textheight}{9in}\n"
		"\\setlength{\\textwidth}{6in}\n"
		"\\setlength{\\oddsidemargin}{0in}\n"
		"\\setlength{\\parindent}{0in}\n"
		"\\setlength{\\parsep}{0.2in}\n"
		"\\setlength{\\headheight}{0in}\n"
		"\\setlength{\\headsep}{0in}\n"
		"\\setlength{\\topmargin}{0in}\n"
		"\\setlength{\\topskip}{0in}\n"
		"\\setlength{\\parskip}{1.2ex}\n\n"
                "\\begin{document}\n\n"
		"{\\small\\sf %s}\\hrule\\vspace*{.1in}\n"
		"{\\small\\sf\n", g_basename(filename));

  for (ac=set->accounts; ac; ac=ac->next)
  {
    FinAccount * account = LIST_GET(FinAccount, ac);
    fprintf(file, "{\\bf %s} : {\\it %s}\n\n" 
    		  "\\begin{tabular}{|l|l|l|l|r|r|}\n"
		  "\\hline\n", account->name, account->info);
    for (rc=account->records; rc; rc=rc->next)
    {
      gchar ** text = fin_stringized_record_new(LIST_GET(FinRecord, rc),
      						fields, 
						sizeof_array(fields));
      fprintf(file, "%s & "  // date
      		    "%s & ", // type
		    text[0], text[1]);

      write_info(file, text[2]); // info

      fprintf(file, " & "
		    "%s & "  // stat
		    "%s & "  // amount
		    "%s "    // balance
		    "\\\\\n",
		    text[3], text[4], text[5]);
    }
    fprintf(file, "\\hline\n\\end{tabular}\n");
  }
 
  fprintf(file, "}\\end{document}\n");

  return TRUE;
}

FinExportFilter FinExport_LaTeX =
{
  "LaTeX",
  "Created by Darin Fisher <dfisher@jagger.me.berkeley.edu>",
  latex_export,
};
