#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <unistd.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <ctype.h>
#include <gnome.h>
#include "gnap.h"
#include "napster.h"

extern GList *sr_list;
extern int napster_socket;
extern GList *searches;

gint nap_connect(gchar *username,gchar *password,gint port,gint connection,gboolean new_user) 
{
 gint socketfd; 
 struct sockaddr_in *them;
 gchar connect_string[200];
 gchar size_string[3];
 gchar buffer[2000];

 socketfd = socket(AF_INET,SOCK_STREAM,0);
 
 them = g_malloc(sizeof(struct sockaddr_in));
 them->sin_family = AF_INET;
 them->sin_port = htons(SERVER_PORT);
 them->sin_addr.s_addr = inet_addr(SERVER_ADDR);
 bzero(&(them->sin_zero), 8);

 if( -1 == connect(socketfd,(struct sockaddr*)them,sizeof(struct sockaddr))) 
  return -1;

 g_free(them);
 // getting best host... 
 if(recv(socketfd,buffer,34,0) == -1)
  return -1;

 close(socketfd);

 // lets reuse these vars :)
 socketfd = socket(AF_INET,SOCK_STREAM,0);
 them = nap_get_best_host(buffer);

 if( -1 == connect(socketfd,(struct sockaddr*)them,sizeof(struct sockaddr))) 
  return -1;

 g_free(them);

 if(new_user) {
  sprintf(connect_string,"%s",username);
  sprintf(size_string,"%c",strlen(connect_string));

  send(socketfd,size_string,2,0);
  send(socketfd,"\7",2,0);
  send(socketfd,connect_string,strlen(connect_string),0);
 }
   
 sprintf(connect_string,"%s %s %i \"%s\" %i",username,password,port,VERSION_STRING,connection);
 sprintf(size_string,"%c",strlen(connect_string));
 send(socketfd,size_string,2,0);
 send(socketfd,"\2",2,0);
 send(socketfd,connect_string,strlen(connect_string),0);

 return socketfd;
} 

// This function parses the best host string from
// the server into ip and port. then creates a 
// sockaddr_in struct for it.
struct sockaddr_in *nap_get_best_host(gchar *string) 
{
 gchar *ip, *port, *c;
 struct sockaddr_in *them;

 them = g_malloc(sizeof(struct sockaddr_in));

 ip = string;
 port = strchr(string,':');
 port[0] = '\0';
 port += sizeof(gchar);
 c = strchr(port,'\n');
 c[0] = '\0';
 
 printf("IP: %s\nPORT: %s\n",ip,port);

 them->sin_family = AF_INET;
 them->sin_port = htons(atoi(port));
 them->sin_addr.s_addr = inet_addr(ip);
 bzero(&(them->sin_zero), 8);

 // i suppose it would be nice if i had some error checking
 // or something.

 return(them);
}

void nap_handle_input(gpointer data,gint socketfd,GdkInputCondition condition) 
{
 gchar buffer[355],buffer2[355];
 gint amount_recv,length,command;

 // TODO error checks 
 recv(socketfd,buffer,4,0); 
   
 length = (gint)buffer[0];
 command = (gint)buffer[2];

 if(buffer[1] != '\0') {
  printf("offset - FUCK what is this bug? someone fix it :~~~\n");
  command = -54;
 }

 if(length < 0)
  length = 256 + length;

 bzero(buffer,sizeof(buffer));
 amount_recv = recv(socketfd,buffer,length,0);
 while(amount_recv < length) {
  bzero(buffer2,sizeof(buffer2));
  amount_recv += recv(socketfd,buffer2,length - amount_recv,0); 
  strcat(buffer,buffer2);
 }
 
 switch(command) {
  case 8:	printf("Your a new user!\n"); break; // recv comfermation of new user
  case 19: 	break;  		
  case -55:	nap_get_search_result(buffer); break;
  case -54:	nap_end_search_result(); break; // end search results.
  case -52:	nap_get_download_reply(socketfd,buffer); break;
  case -42: 	gnap_status(buffer); break; 			
  case 109: 	break;
  default:	printf("%s\n",buffer); break;
 }
}

void nap_end_search_result(void) 
{
 GList *last;
 last = g_list_last(searches);
 searches = g_list_remove_link(searches,last);
}

void nap_send_search(gchar* search,int socket) 
{
 gchar length[2],query[255];

 // TODO: different size search results
 sprintf(query,"FILENAME CONTAINS \"%s\" MAX_RESULTS 100",search); 
 sprintf(length,"%c",strlen(query));
 
 send(socket,length,2,0);
 send(socket,"\310",2,0);

 send(socket,query,strlen(query),0);

 // push
 searches = g_list_append(searches,search);
}

void nap_get_search_result(gchar* line) 
{
 search_result *result = NULL; 
 gchar *filename,user[40],id[40];
 guint number,size,bitrate,frequency,speed;
 guint32 ip;
 
 result = g_malloc(sizeof(search_result));

 filename = line;
 // gets rid of first "
 filename += sizeof(gchar);
 // get rid of second one
 line = (gchar*)strchr(filename,'\"');
 if(!line) {
  printf("strange filename error\n");
  return;
 }
 line[0] = '\0';
 line += sizeof(gchar);

 sscanf(line," %s %u %d %d %d %s %u %d",id,&size,&bitrate,&frequency,&number,user,&ip,&speed);

 result->filename = g_strdup(filename);   
 result->id = g_strdup(id);
 result->number = number;
 result->ip = ip;
 result->user = g_strdup(user);
 result->size = size;
 result->bitrate = bitrate;
 result->frequency = frequency;
 result->speed = speed;
 result->selected = 0;

 gnap_add_search_result(result);
}

void nap_send_download_request(gint socket,gchar *user,gchar *filename,gchar *id) 
{
 gchar line[256],c[2]; 

 sprintf(line,"%s \"%s\"",user,filename); 
 sprintf(c,"%c",strlen(line)); 
 send(socket,c,2,0);
 send(socket,"\313",2,0);
 send(socket,line,strlen(line),0);
}

void nap_get_download_reply(gint sock,gchar *buffer) 
{
 GList *i;
 transfer *download;
 search_result *data;
 struct sockaddr_in them;
 gchar line[255],*path,*filename,*rest,user[40],id[40];
 gint port,speed,counter;
 guint ip;

 i = sr_list;

 filename = strchr(buffer,'\"'); 
 filename[0] = '\0';
 filename += sizeof(gchar);
 rest = strchr(filename,'\"');
 rest[0] = '\0';
 rest += sizeof(gchar);
 sscanf(buffer,"%s %u %d ",user,&ip,&port);
 sscanf(rest," %s %d",id,&speed);

 // ok we are going to connect and start downloading in one
 // fell swoop. this will proably hang the application a bit
 // on slow connections!@#!@#!
 // however i can't think of a way around this at the moment,
 // someday we can split this up into its own function.
  
 do {
  data = (search_result*)i->data; 
 } while((i = i->next) && strcmp(id,data->id));  

 download = g_malloc(sizeof(transfer));
 download->user = g_strdup(user); 
 download->filename = g_strdup(gnap_strip_path(filename));
 download->socket = socket(AF_INET,SOCK_STREAM,0);
 download->totalsize = data->size;
 them.sin_family = AF_INET;
 them.sin_port = htons(port);
 them.sin_addr.s_addr = ip;
 bzero(&(them.sin_zero), 8);

 // TODO: fix me
 if(strstr(inet_ntoa((struct in_addr)them.sin_addr),"255")) { // check if its a messed up ip
  gnap_error_dialog("Bad IP: ",inet_ntoa((struct in_addr)them.sin_addr));
  close(download->socket);
  g_free(download);
  return;
 }

 if(connect(download->socket,(struct sockaddr *)&them,sizeof(struct sockaddr))) {
  gnap_error_dialog("Did not connect to ",inet_ntoa((struct in_addr)them.sin_addr));
  close(download->socket);
  //g_free(download);
  return;
 }
 
 sprintf(line,"%s \"%s\" %d", gnome_config_get_string("/gnap/General/username"),
		 filename, gnome_config_get_int("/gnap/General/connection"));

 send(download->socket,"GET",3,0);
 send(download->socket,line,strlen(line),0);

 bzero(line,sizeof(line)); 

 // figure out the path.
 path = gnome_config_get_string("/gnap/General/download_dir");
 for(counter = 0;path[counter+1]; counter++);
 if(path[counter] == '/') {
  sprintf(line,"%s%s",path,gnap_strip_path(filename)); 
 } else {
  sprintf(line,"%s/%s",path,gnap_strip_path(filename)); 
 }

 download->filehandle = fopen(line,"w");

 if(!download->filehandle) {
  gnap_error_dialog("Could Not Open File: ",line);
  close(download->socket);
  //g_free(download);
 } else {
  download->tag = gdk_input_add(download->socket,GDK_INPUT_READ,nap_handle_header,download);
 }
}

void nap_handle_header(gpointer data,gint socketfd,GdkInputCondition condition) 
{
 gchar c;
 transfer *download;
 download = (transfer*)data;

 recv(download->socket,&c,1,MSG_PEEK);
 if(c == '\377') {
  gdk_input_remove(download->tag);
  gnap_download_add(download);
 } else { 
  recv(download->socket,&c,1,0);
 }
}

void nap_handle_download(gpointer data,gint socketfd,GdkInputCondition condition)
{
 gchar buffer[2048];
 gint amount_recv;
 transfer *download;

 download = (transfer*)data;
   
 bzero(buffer,sizeof(buffer));
 amount_recv = recv(socketfd,buffer,2048,0); 
 if(!amount_recv) {
  gnap_download_end(download);
 } else {
  fwrite(buffer,amount_recv,sizeof(gchar),(FILE *)download->filehandle);
  download->size +=  amount_recv;
 } 
}
