#include "portable.h"
#include "chinese.h"
#include "vga.h"
static void NULL_FUNC();
void (*mon_init)()=NULL_FUNC;
void (*mon_grmode)()=NULL_FUNC;
void (*mon_textmode)()=NULL_FUNC;
void (*mon_clearblock)(int sx,int sy ,int ex,int ey)=NULL_FUNC;
int (*mon_setcolor)(int)=(int (*)())NULL_FUNC;
void (*mon_moveleft)(int sx,int ex,int y,int c)=NULL_FUNC;
void (*mon_moveright)(int sx,int ex,int y,int c)=NULL_FUNC;
void (*mon_drawctext)(int x,int y,char *)=NULL_FUNC;
void (*mon_drawtext)(int x,int y,char *)=NULL_FUNC;
void (*mon_drawcachefont)(int,int,int)=NULL_FUNC;
void (*mon_addcachefont)(int)=NULL_FUNC;
void (*mon_maxcachefont)()=NULL_FUNC;
void (*mon_expandfont)(char *,char *,int,int)=NULL_FUNC;
void (*mon_install256)(int x,char *)=NULL_FUNC;
void (*mon_remove256)(int x)=NULL_FUNC;
void (*mon_invert)(int)=NULL_FUNC;
void (*mon_underline)(int)=NULL_FUNC;
void (*mon_scroll)(int sy,int ey,int l)=NULL_FUNC;
void (*mon_rscroll)(int sy,int ey,int l)=NULL_FUNC;
void (*mon_drawline)(int sx,int sy,int ex,int ey)=NULL_FUNC;
void (*mon_cursor)(int x,int y)=NULL_FUNC;
int (*mon_curcolor)()=NULL_FUNC;
int (*mon_fontsize)(int w,int h)=NULL_FUNC;

GDRIVER sys_graphics_driver[] = {
  {"vga",vga1_init_console},
#ifdef SVGALIB
  {"svgalib",svga_init_console},
#endif
  {NULL,NULL}};


static void NULL_FUNC()
{
    SYSERR("NULL FUNC execute");
}
static void expandfont(char *buf1,char *buf2,int w,int h)
{
  int len;

  len = (w%8)? (w/8+1):w/8;
  memcpy(buf2,buf1,(len*h));
}
static void graph_mode()
{
  vga1_setmode(G640x480x16);
}
static void text_mode()
{
  vga1_setmode(TEXT);
}
static int v_fontsize(int w,int h)
{
  return ((w+7)>>3)*h;
}
void vga1_init_console()
{
  mon_grmode = graph_mode;
  mon_textmode = text_mode;
  mon_clearblock = vga1_clearblock;
  mon_setcolor = vga1_setcolor;
  mon_moveleft = vga1_moveleft;
  mon_moveright = vga1_moveright;
  mon_drawctext = vga1_drawctext;
  mon_drawtext = vga1_drawtext;
  mon_expandfont = expandfont;
  mon_invert = vga1_invert;
  mon_underline = vga1_underline;
  mon_drawline = (void (*)())vga1_drawline;
  mon_scroll = vga1_scroll;
  mon_rscroll = vga1_rscroll;
  mon_cursor = vga1_cursor;
  mon_curcolor = vga1_curcolor;
  mon_fontsize = v_fontsize;
}

