/* Copyright(C) 1993
   The following program is used to display Chinese character in screen
   console without X Window System in Linux.  The program is protected
   under GNU copyleft.  The detailed is as GNU's COPYING which I have
   included in this package.  You can distribute this program freely, but
   YOU MUST DISTRIBUTE THE COMPLETE CODE IN THE PACKAGE.  If you have
   modified the package, you must note it in README file and tell others
   how to get the original version.
*/
/************************************************************************/
/*   Build Date 08/23/1993                                              */
/*        09/08/1993                                                    */
/*           (1) Add key F9 to swap between Chinese input and english   */
/*               input.                                                 */
/************************************************************************/
/* $Id: input.c,v 1.1 1994/05/08 02:43:36 root Exp root $ */

#define CHINESE_SYSTEM
#include <stdio.h>
#include <malloc.h>
#include <stdlib.h>
#include <ctype.h>
#include <fcntl.h>
#include <unistd.h>
#include "chinese.h"
#include "vga.h"
#include "fullsize.h"
#include "input.h"
#include "font.h"

static  MultipleTable *mtab[10];
void clear_inputmethod();
static void add_string(CHAR *);
ConsoleSystemTable systemtab[CONS_NUM];
ConsoleSystemTable *nowconsole;
static char *addfull(char *,char c);
static void *inputmethod[10];
#define ERROR_X 75
#define BIG5_0 0xa2af
#define BIG5_A 0xa2cf
int BIG5_inputmethod(CHAR *,CHAR *,int);
void clearslot_inputmethod();
void mark_inputmethod(char *);
void alert_inputmethod();
void ch_input_redraw();
FILE *debugfile=NULL;
int Multiple_inputmethod(CHAR *,CHAR *,int);
int Phone_inputmethod(CHAR *,CHAR *,int );
char *add_macrokey(char *tok,char *buf);
static int  chconsole;

void input_init()
{
  int i;

  debugfile = fopen("/dev/tty8","w");
  method = 0;
  for(i=0;i<CONS_NUM;i++)
    {
      nowconsole = &systemtab[i];
      method = 0;
      state = 0;
      parn = 0;
      par = 0;
      mule = 0;
      tokbuf = f11buf;
      cachebuf = pbuf;
      multi_init  = 0;
      swap_input_method = 1;
      isfull = 0;
      chstate = STATE_NORMAL;
    }
  nowconsole = &systemtab[0];
  chconsole = 0;
  inputmethod[0] = (void *) BIG5_inputmethod;
  inputmethod[1] = (void *) Phone_inputmethod;
  for(i=2;i<10;i++)
    inputmethod[i] =  Multiple_inputmethod;
  Multiple_inputmethod(NULL,NULL,0);
  Phone_inputmethod(NULL,NULL,0);
}
void Read_Input_Config()
{
    Init_macrokey();
}
/* F11 \033[23~ switch to text */



/* 
   cache the read input into pbuf[], the end of the input is 
   cachebuf.  The function preread is very ill-style.  It should be
   rewritten soon.
*/

#define DEBUG_STRING "Debug(f x):"
void chinese_command(CHAR c)
{
    int ww;
    extern int write_to_screen;

    SYSERR("Chinese command");
    if (chstate == STATE_NORMAL)
      {
	  switch(c)
	    {
	      case '0':
		Read_Config();
		break;
	      case '1':
		ww = ch_wordalign(-1,-1);
		ch_wordalign(-1,1-ww);
		ch_input_redraw();
		break;
	      case '2':
		mule = 1 - mule;
		ch_input_redraw();
		break;
	      case 'I':
		chstate = STATE_METHOD;
		ii = 0;
	        return;
	      case 'C':
		if (write_to_screen)
		  {
		    ch_redraw();
		  }
		break;
	      case '@':
		chstate = STATE_PROTECT;
		*tokbuf++='@';
		if (method != 0)
		  *cachebuf++= -1;
		return;
	      case 'S':
		chstate = STATE_SWITCH_CONSOLE;
		ii = 0;
		*tokbuf++ = 'S';
		return;
	      case 'Z':
		chstate = STATE_MACROKEY;
		tokbuf = f11buf;
		return;
	      /*************************/
	      /* Graphics sequence set */
	      /*************************/
	      case 'L':
		chstate = STATE_LINE;
		memset(grpara,0,sizeof(grpara));
		grpara[5] = GR_LINE;
		grnum = grstat = 0;
		return;
	      case 'E':
		chstate = STATE_CIRCLE;
		memset(grpara,0,sizeof(grpara));
		grnum = grstat = 0;
		return;
	      case 'P':
		chstate = STATE_PAINT;
		memset(grpara,0,sizeof(grpara));
		grnum = grstat = 0;
		return;
	    }
	  tokbuf=f11buf;
	  state = STATE_NORMAL;
      }
    else if (chstate == STATE_PROTECT)
      {
	  if (c == '@')
	    {
		/* the string is end */
		if (method!=0)
		  *cachebuf++ = -1;
		chstate = state = STATE_NORMAL;
		tokbuf = f11buf;
	    }
	  else
	    {
		*cachebuf++ = c;
	    }
	  return;
      }
    else if (chstate == STATE_MACROKEY)
      {
	  if ((c<='9') && (c >='0'))
	    *tokbuf++ = c;
	  else if (c == '@')
	    {
		*tokbuf = 0;
		cachebuf = add_macrokey(f11buf,cachebuf);
		chstate = state = STATE_NORMAL;
		tokbuf = f11buf;
	    }
	  else
	    {
		chstate = state = STATE_NORMAL;
		tokbuf = f11buf;
	    }
      }
    else if (chstate ==  STATE_METHOD)
      {
	if (c == 'Q')
	  {
	    sigquit(0);
	  }
	if (c<='9' && c >= '0')
	  ii = ii * 10 + c - '0';
	else if (c == '@')
	  {
	    if (ii < 12)
	      ch_inputmethod(ii);
	    chstate = state = STATE_NORMAL;
	    tokbuf = f11buf;
	  }
	else if (c == 'N')
	  {
	    /* switch to ascii mode */
	      if (method != 0)
		{
		  clear_inputmethod();
		  clearslot_inputmethod();
		  swap_input_method = method;
		  ch_inputmethod(0);
		}
	      chstate=state = STATE_NORMAL;
	      tokbuf = f11buf;
	  }
	else if (c =='C')
	  {
	    /* switch to chinese mode */
	      if (method == 0)
		{
		  clear_inputmethod();
		  clearslot_inputmethod();
		  ch_inputmethod(swap_input_method);
		  swap_input_method = 0;
		}

	      chstate=state = STATE_NORMAL;
	      tokbuf = f11buf;
	  }
	else if (c == 'c')
	  {
	    /* toggle between ASCII and Chinese mode */
	      if (method == 0)
		{
		  clear_inputmethod();
		  clearslot_inputmethod();
		  ch_inputmethod(swap_input_method);
		  swap_input_method = 0;
		}
	      else
		{
		  clear_inputmethod();
		  clearslot_inputmethod();
		  swap_input_method = method;
		  method = 0;
		  ch_inputmethod(-1);
		}

	      state = STATE_NORMAL;
	      chstate = STATE_NORMAL;
	      tokbuf = f11buf;
	  }
	else if ( c == 'T')
	  {
	    /* close cursor adjust mode */
	    ch_wordalign(chconsole,0);
	    tokbuf = f11buf;
	    chstate=state = STATE_NORMAL;
	  }
	else if ( c == 't')
	  {
	    /* toggle cursor adjust mode */
	    if (ch_wordalign(chconsole,-1))
	      ch_wordalign(chconsole,0);
	    else
	      ch_wordalign(chconsole,1);
	    tokbuf = f11buf;
	    chstate=state = STATE_NORMAL;
	  }
	else if (c == 'F')
	  {
	    /* switch to full mode */
	    isfull = 1;
	    tokbuf = f11buf;
	    chstate=state = STATE_NORMAL;
	    ch_inputmethod(-1);
	  }
	else if (c == 'f')
	  {
	    /* toggle between full and half mode */
	    isfull = (isfull)? 0 : 1;
	    tokbuf = f11buf;
	    chstate = state = STATE_NORMAL;
	    ch_inputmethod(-1);

	  }
#if 0
	else if (c == 'M')
	  {
	    /* turn off status line */
	  }
	else if ( c == 'm')
	  {
	    /* toggle status line */
	  }
#endif
	else 
	  {
	    chstate = state = STATE_NORMAL;
	    tokbuf = f11buf;
	  }
      }
    else if (chstate == STATE_SWITCH_CONSOLE)
      {
	if (c >= '0' && c <= '9')
	  {
	    ii = ii * 10 + c - '0';
	  }
	else if (c == '@')
	  {
	    if (ii >= 0 && ii < CONS_NUM)
	      delay_open_console(ii);
	    chstate = state = STATE_NORMAL;
	    tokbuf = f11buf;
	  }
	else
	  {
	    chstate = state = STATE_NORMAL;
	    tokbuf = f11buf;
	  }	    
      }
    else if (chstate != STATE_NORMAL)
      {
	graphics_sequence_set(c);
      }
    else
      {
	  chstate = state = STATE_NORMAL;
	  tokbuf = f11buf;
      }
	      
}

#define DEBUG_END 1
#define DEBUG_BEGIN 2
#define DEBUG_FONT 3

int ch_input_status(int con) 
{
    if (con < 0 || con >= CONS_NUM)
	return -1;
    return systemtab[con]._state;
}


static void debug_mode(CHAR c)
{
  *cachebuf++=c;
  switch(debug)
    {
    case DEBUG_BEGIN:
      switch(c)
	{
	case 'f':
	  debug = DEBUG_FONT;
	  add_string("Font(c s):");
	  break;
	case 'x':
	  debug = DEBUG_END;
	  add_string("Exit debug\n");
	  break;
	default:
	  state = STATE_NORMAL;
	}
      break;
    case DEBUG_FONT:
      switch(c)
	{
	case 'c':
	  add_string("List cache buffer in origin console\n");
	  FontCache_list();
	  debug = DEBUG_BEGIN;
	  break;
	case 's':
	  add_string("Show state of font cache\n");
	  FontCache_state();
	  debug = DEBUG_BEGIN;
	  break;
	default:
	  state = STATE_NORMAL;
	}
    default:
      debug = state = STATE_NORMAL;
      break;
    }
  
}

static void add_string(CHAR *s)
{
  while(*s)
    *cachebuf++ = *s++;
}

void preread(CHAR *buf,int len)
{
  char *ss = buf;
  int i;

  if (len < 0)
    {
	state = STATE_NORMAL;
	if (tokbuf != f11buf)
	  {
	      memcpy(cachebuf,f11buf,tokbuf-f11buf);
	      cachebuf += (tokbuf-f11buf);
	      tokbuf = f11buf;
	  }
	SYSERR("flush buffer");
	return;
    }
  
  for(i=0;i<len;i++)
    {
      switch(state)
	{
	case STATE_NORMAL:
	  if (*ss == 27)
	    {
	      state = STATE_ESC;
	      tokbuf = f11buf;
	      *tokbuf = 27;
	      tokbuf++;
	    }
	  else
	    {
	      *cachebuf++ = *ss++;
	      continue;
	    }
	  break;	   
	case STATE_CHCOMMAND:
	  SYSERR("Chinese command");
	  chinese_command(*ss);
	  break;
	case STATE_ESC:
	  /*
	     O : vt100
	     ? : vt52
	     [ : function key
	     % : private chdrv command
	   */
	  if ((*ss == '[')||(*ss == 'O')||(*ss=='?'))
	    {
	      state = STATE_FS1;
	      *tokbuf++= *ss;
	    }
	  else if (*ss == '%')
	    {
	      SYSERR("Chinese");
	      state = STATE_CHCOMMAND;
	      *tokbuf++ = '%';
	    }
	  else if (*ss == 'n' ) /* Alt-N for next console*/
	  {
	      delay_open_next_console();
	      state = STATE_NORMAL;
	      tokbuf = f11buf;
	  }
	  /* The following block breaks Emacs, so comment it out */
#if 0	  
	  else if( *ss == 'x' ) /* ALT-X  for quit */
	  {
	      int oldx = ch_wherex();
	      int oldy = ch_wherey();

	      ch_goto_systemarea(TAG_X);
	      ch_system_showstr("  Do you really want to quit it ? ");
	      ch_restore_cursor();
	      
	      state = STATE_SWITCH_CONSOLE;
	  }
#endif
	  else
	    state = STATE_NORMAL;
	  break;
	case STATE_FS1:
	  if (*ss == '2')
	    {
	      state = STATE_FS2;
	      *tokbuf++ = '2';
	    }
	  else if (*ss >=0 && *ss <='9')
	    {
	      state = STATE_FN;
	      *tokbuf++ = *ss;
	    }
	  else if (*ss>='A'&&*ss<='Z')
	    {
	      /* we use \255xxxxxxx\255  to let input method don't explain
		 thease key sequence */
	      lastspecial = *ss;
	      if (method != 0)
		{
		  *cachebuf++ = 255;
		  memcpy(cachebuf,f11buf,tokbuf-f11buf);
		  cachebuf += (tokbuf-f11buf);
		  *cachebuf++ = *ss;
		  *cachebuf++= 255;
		  tokbuf = f11buf;
		  state = STATE_NORMAL;
		  ss++;
		  continue;
		}
	      state = STATE_NORMAL;
	    }
	  else if (*ss == '[')
	    {
	      state = STATE_FS3;
	      *tokbuf++ = '[';
	    }
	  else
	    state = STATE_NORMAL;
	  break;
	case STATE_FS3:
#ifndef DISABLE_FUNCTION_KEY
	  switch(*ss)
	    {
	    case 'A':
	      state = STATE_SWITCH_CONSOLE;
	      break;
	    default:
	      memcpy(cachebuf,f11buf,tokbuf-f11buf);
	      cachebuf += (tokbuf-f11buf);
	      tokbuf = f11buf;
	    }
#else
	  state = STATE_NORMAL;
#endif
	  break;
	case STATE_SWITCH_CONSOLE:
	  if (*ss>='0'&& *ss<='9')
	    {
	      /* change virtual console occurs when return to
	         chdrv.c                                      
		*/
	      delay_open_console(*ss-'0');
	    }
#if 0
	  else if (*ss == 'a')
	    {
	      state = STATE_DEBUG;
	      debug = DEBUG_BEGIN;
	      add_string(DEBUG_STRING);
	      break;
	    }
#endif
	  else if (*ss == 'q')
	  	sigquit(0);
	  else if (*ss == 'y')
	  	kill_current_console();
	  
	  tokbuf = f11buf;
	  state = STATE_NORMAL;
	  break;
	case STATE_FN:
	  if (*ss == '~')
	    {
	      *cachebuf++ = 255;
	      memcpy(cachebuf,f11buf,tokbuf-f11buf);
	      cachebuf += (tokbuf-f11buf);
	      *cachebuf++ = *ss;
	      *cachebuf++= 255;
	      tokbuf = f11buf;
	      state = STATE_NORMAL;
	      ss++;
	      continue;
	    }
	  else if (tokbuf-f11buf < 10)
	    *tokbuf++=*ss;
	  else
	    state = STATE_NORMAL;
	  break;
	case STATE_FS2:
	  switch(*ss)
	    {
	    case '3':
	      state = STATE_F11;
	      *tokbuf++ = '3';
	      break;
	    case '4':
	      state = STATE_F12;
	      *tokbuf++ = '4';
	      break;
	    case '1':
	      state = STATE_F10;
	      *tokbuf++='1';
	      break;
	    case '0':
	      state = STATE_F9;
	      *tokbuf++ = '0';
	      break;
	    default:
	      state=STATE_SPEC2;
	    }
	  break;
	case STATE_F11:
	  if (*ss == '~')
	    {
	      tokbuf = f11buf;
	      state = STATE_NORMAL;
	      mule = (mule)? 0:1;
	      ch_inputmethod(-1);
	    }
	  else
	    state = STATE_NORMAL;
	  break;
	case STATE_F12:
#ifndef DISABLE_FUNCTION_KEY
	  if (*ss == '~')
	    {
	      isfull = (isfull)? 0 : 1;
	      tokbuf = f11buf;
	      state = STATE_NORMAL;
	      ch_inputmethod(-1);
	    }
	  else
#endif
	    state = STATE_NORMAL;
	  break;
	case STATE_F10:
#ifndef DISABLE_FUNCTION_KEY
	  if (*ss == '~')
	    {
	      ch_goto_systemarea(TAG_X);
	      ch_system_showstr("Select a input method(0-9) ");
	      ch_restore_cursor();
	      tokbuf = f11buf;
	      state = STATE_SELE;
	    }
	  else
#endif
	    state = STATE_NORMAL;
	  break;
	case STATE_F9:
#ifndef DISABLE_FUNCTION_KEY
	  if (*ss == '~')
	    {
	      if (method == 0)
		{
		  clear_inputmethod();
		  clearslot_inputmethod();
		  ch_inputmethod(swap_input_method);
		  swap_input_method = 0;
		}
	      else
		{
		  clear_inputmethod();
		  clearslot_inputmethod();
		  swap_input_method = method;
		  ch_inputmethod(0);
		}

	      state = STATE_NORMAL;
	      tokbuf = f11buf;
	    }
	  else

#endif
	    state = STATE_NORMAL;
	  break;
	case STATE_SELE:
	  SYSERR1("select %c",*ss);
	  if (*ss <='9' && *ss >='0')
	    {
	      ch_inputmethod(*ss-'0');
	      ch_goto_systemarea(TAG_X);
	      ch_system_showstr("                          ");
	      ch_restore_cursor();

	      state = STATE_NORMAL;
	    }
	  else
	    {
		alert_inputmethod();
		state = STATE_NORMAL;
	    }
	  break;
	case STATE_SPEC2:
	  /* we use ^[|xxxxxxx^[|  to let input method don't explain
	     thease key sequence */
	  *cachebuf++ = 255;
	  memcpy(cachebuf,f11buf,tokbuf-f11buf);
	  cachebuf += (tokbuf-f11buf);
	  *cachebuf++ = *ss;
	  *cachebuf++= 255;
	  tokbuf = f11buf;
	  state=STATE_NORMAL;
	  break;
#if 0
	case STATE_DEBUG:
	  debug_mode(*ss);
	  if (debug == DEBUG_END)
	    {
	      state = STATE_NORMAL;
	      tokbuf = f11buf;
	    }
	  break;
#endif
	default:
	  SYSERR1("system unstable code = %d",state);
	  state = STATE_NORMAL;
	}
      
      
      if ((state == STATE_NORMAL) && (tokbuf != f11buf))
	{
	  memcpy(cachebuf,f11buf,tokbuf-f11buf);
	  cachebuf += (tokbuf-f11buf);
	  *cachebuf++ = *ss;
	  tokbuf = f11buf;
	}
      ss++;
    }
  /* The below code is a hack only.It let vi and other appllication taht
     need ESC key work comfortable but it MAYBE break if a sequence of 
     char is divide into several block.
     */
  if(state == STATE_ESC)
    {
	*cachebuf++='\033';
	tokbuf = f11buf;
	state = STATE_NORMAL;
    }
}

void input_insert_left(int con)
{
    ConsoleSystemTable *ss;
    
    if (con == -1)
      ss = nowconsole;
    else
      ss = systemtab + con;
    
    if (ss->_lastspecial != 'D')
      {
	  ss->_lastspecial = 0;
	  return;
      }
    if (ss->_method != 0)
      *ss->_cachebuf++ = 255;
    memcpy(ss->_cachebuf,"\033[D",3);
    ss->_cachebuf += 3;
    if (ss->_method != 0)
      *ss->_cachebuf++=255;
    ss->_lastspecial = 0;
}
void input_insert_right(int con)
{
    ConsoleSystemTable *ss;

    if (con == -1)
      ss = nowconsole;
    else
      ss = systemtab + con;

    if (ss->_lastspecial != 'C')
      {
	  ss->_lastspecial = 0;
	  return;
      }
    if (ss->_method != 0)
      *ss->_cachebuf++ = 255;
    memcpy(ss->_cachebuf,"\033[C",3);
    ss->_cachebuf += 3;
    if (ss->_method != 0)
      *ss->_cachebuf++=255;
    ss->_lastspecial = 0;
}
void input_insert_any(int con)
{
    ConsoleSystemTable *ss;

    if (con == -1)
      ss = nowconsole;
    else
      ss = systemtab + con;

    if (ss->_lastspecial == 'C')
      {
	  if (ss->_method != 0)
	    *ss->_cachebuf++ = 255;
	  memcpy(ss->_cachebuf,"\033[C",3);
	  ss->_cachebuf += 3;
	  if (ss->_method != 0)
	    *ss->_cachebuf++ = 255;

	  SYSERR("insert right");
      }
    else if (ss->_lastspecial == 'D')
      {
	  if (ss->_method != 0)
	    *ss->_cachebuf++ = 255;

	  memcpy(ss->_cachebuf,"\033[D",3);
	  ss->_cachebuf += 3;
	  if (ss->_method != 0)
	    *ss->_cachebuf++ = 255;

	  SYSERR("insert left");
      }
    else
      SYSERR2("insert %dto console %d",ss->_lastspecial,con);
    ss->_lastspecial = 0;

}
	  

int _ccread(int fd,CHAR *buf,int len);

int _cread(char *buf,int len)
{
  return _ccread(0,buf,len);
}

int _ccread(int fd,CHAR *buf,int len)
{
  INTFUNC m;
  int oldlen=len;
  
  if (!isfull)
    oldlen = (len>MAX_READ_BUFFER)? MAX_READ_BUFFER:len;
  else
    oldlen = (len>MAX_READ_BUFFER/2)? MAX_READ_BUFFER/2:len;
  len = read(fd,buf,oldlen);

  preread(buf,len);

  if (cachebuf == pbuf)
    if (len <= 0)
      return 0;
    else
      return _ccread(fd,buf,oldlen);

  if (method == 0)
    {
      CHAR *ssbuf = pbuf;
      CHAR *ddbuf = buf;
      len = cachebuf-pbuf;
      while(ssbuf != cachebuf)
	if (*ssbuf != 255)
	  if (isfull)
	    ddbuf = addfull(ddbuf,*ssbuf++);
	  else
	    *ddbuf++=*ssbuf++;
	else
	  {
	    ssbuf++;
	    while((ssbuf != cachebuf) && (*ssbuf != 255))
	      *ddbuf++=*ssbuf++;
	    ssbuf++;
	  }
      len = ddbuf-buf;
      cachebuf = pbuf;
      return len;
    }
  else
    {
      m = (INTFUNC) inputmethod[method-1];
      if (m)
	{
	  len = m(pbuf,buf,cachebuf-pbuf);
	  cachebuf = pbuf;
	  return len;
	}
      else
	{
	  memcpy(buf,pbuf,cachebuf-pbuf);
	  cachebuf = pbuf;
	  return cachebuf-pbuf;
	}
    }
}

int ch_read_from_buffer(CHAR *sbuf,CHAR *dbuf,int len)
{
  INTFUNC m;
  
  if (len == -1)
    {
	if (sbuf != NULL)
	  preread(sbuf,-1);
    }
  else 
    {
	len = (len >MAX_READ_BUFFER)? MAX_READ_BUFFER : len;

	preread(sbuf,len);
    }

  if (cachebuf == pbuf)
    return 0;
  
  if (method == 0)
    {
      CHAR *ssbuf = pbuf;
      CHAR *ddbuf = dbuf;
      len = cachebuf-pbuf;
      while(ssbuf != cachebuf)
	if (*ssbuf != 255)
	  if (isfull)
	    ddbuf = addfull(ddbuf,*ssbuf++);
	  else
	    *ddbuf++=*ssbuf++;
	else
	  {
	    ssbuf++;
	    while((ssbuf != cachebuf) && (*ssbuf != 255))
	      *ddbuf++=*ssbuf++;
	    ssbuf++;
	  }
      len = ddbuf-dbuf;
      cachebuf = pbuf;
      return len;
    }
  else
    {
      m = (INTFUNC) inputmethod[method-1];
      if (m)
	{
	  len = m(pbuf,dbuf,cachebuf-pbuf);
	  cachebuf = pbuf;
	  return len;
	}
      else
	{
	  memcpy(dbuf,pbuf,cachebuf-pbuf);
	  len = cachebuf - pbuf;
	  cachebuf = pbuf;
	  return len;
	}
    }
}

char *_cgets(char *buf,int len)
{
  INTFUNC m;

  len = (len>MAX_READ_BUFFER)? MAX_READ_BUFFER:len;
  len = strlen(fgets(buf,len,stdin));
  preread(buf,len);
  if (cachebuf == pbuf)
    if (len == 0)
      return NULL;
    else
      return _cgets(buf,len);
  if (method == 0)
    {
      if (isfull)
	{
	  CHAR *ssbuf = pbuf;
	  CHAR *ddbuf = buf;

	  while(ssbuf != cachebuf)
	    ddbuf = addfull(ddbuf,*ssbuf++);
	}
      else
	memcpy(buf,pbuf,len);

      cachebuf = pbuf;
      return buf;
    }
  else
    {
      m = (INTFUNC) inputmethod[method-1];
      if (m)
	{
	  len = m(pbuf,buf,cachebuf-pbuf);
	  buf[len]=0;
	  cachebuf = pbuf;
	  return buf;
	}
      else
	{
	  memcpy(pbuf,buf,cachebuf-pbuf);
	  buf[cachebuf-pbuf] = 0;
	  cachebuf = pbuf;
	  return buf;
	}
    }
}

void alert_inputmethod()
{
  ch_showch(7);
}

void show_inputmethod(int c,int loc)
{
  int oldx,oldy;
  oldx = ch_wherex();
  oldy = ch_wherey();
  ch_goto_systemarea(TAG_X+loc*2+1);
  ch_showBIG5(c);
  ch_restore_cursor();

}
void clear_inputmethod()
{
  int oldx,oldy,i;

  oldx = ch_wherex();
  oldy = ch_wherey();
  
  for(i=0;i<5;i++)
    {
      ch_goto_systemarea(TAG_X+i*2+1);
      ch_showBIG5(0xa140);
    }
  ch_restore_cursor();

}
void error_inputmethod()
{
  
  ch_goto_systemarea(ERROR_X);
  ch_system_showstr("ERROR");
  ch_restore_cursor();
}

void mark_inputmethod(char *s)
{
  int i;

  ENTER;

  ch_goto_systemarea(TAG_X-11);
  if (mule)
      ch_system_showch('M');
  else
      ch_system_showch(' ');

  if (ch_wordalign(-1,-1))
    ch_system_showch('H');
  else
    ch_system_showch(' ');
  ch_goto_systemarea(TAG_X-9);
  if (isfull)
    ch_system_showstr("[]");
  else
    ch_system_showstr("[b]");
  ch_goto_systemarea(TAG_X-5);

  for(i=0;i<6;i++)
    if (*s)
      ch_system_showch(*s++);
    else
      break;

  ch_restore_cursor();
  LEAVE;
}
  
void slot_inputmethod(int slot,WORD big5)
{
  ch_goto_systemarea(TAG_X+11+slot*4);
  ch_system_showch('1'+slot);
  ch_showBIG5(big5);
  ch_restore_cursor();
}
void clearslot_inputmethod()
{
  
  ch_goto_systemarea(TAG_X+11);
  ch_system_clreol();
  ch_goto_systemarea(65);
  ch_system_showstr("@:");
  ch_restore_cursor();
}
char *add_inputmethod(WORD w,char *dbuf)
{
  int i,j;
  unsigned char b1,b2;
  b1 = ((char *) &w)[1];
  b2 = ((char *) &w)[0];
  if (mule)
    if (ch_codesystem() == CODE_BIG5)
      {
	int ccc;

	ccc = (b1-0xa1)*(0xff-0xa1+0x7f-0x40)+b2-
	  (b2<0x7f? 0x40 : 0x62);
	*dbuf++ =27;*dbuf++ ='$';*dbuf++ ='(';
	if (((b1 << 8)|b2) < 0xc6a1)
	  *dbuf++ = '0';
	else 
	  *dbuf++ = '1';
	*dbuf++ =ccc / (0xff-0xa1)+0x21;
	*dbuf++ =(ccc % (0xff-0xa1))+0x21;
	*dbuf++ =27;*dbuf++ ='(';*dbuf++ ='B';
	for(j=0;j<5;j++)
	  show_inputmethod(0xa140,j);
	parn=0;
	i--;
	return dbuf;
      }
  *dbuf++ = b1;
  *dbuf++ = b2;
  return dbuf;
}  
void ch_inputmethod(int i)
{
  INTFUNC m;
  if (i == -1 )
    {
      if (method == 0)
	{
	    mark_inputmethod("[^]");
	    return;
	}
      m = inputmethod[method-1];
      m(NULL,NULL,-1);
      return;
    }
  
  if (i > 10)
    return;
  
  if (!inputmethod[i-1])
    return;
    
      
  SYSERR1("input table %d",method);
  
  method = i;
  if (method == 0)
    mark_inputmethod("[^]");

  else if (method == 1)
    BIG5_inputmethod(NULL,NULL,-1);
  else if ( method == 2)
    Phone_inputmethod(NULL,NULL,-1);
  else if (inputmethod[method-1])
    {
      m = inputmethod[method-1];
      m(NULL,NULL,i-2);
    }
}
void ch_change_input(int newconsole)
{
  nowconsole = &systemtab[newconsole];
  chconsole = newconsole;
  SYSERR1("console %d\n",newconsole);
}
void ch_input_redraw()
{
  ch_inputmethod(-1);
}

static char *addfull(char *dbuf,char c)
{
  if ((c >=32) && (c <=126))
    {
      if (mule)
	if (ch_codesystem() == CODE_BIG5)
	  {
	    unsigned cc;
	    *dbuf++=27;*dbuf++='$';*dbuf++='(';
	    *dbuf++ = '0';
	    cc = (FULL_SIZE_FONT_CODE[(int)c-32][1]-0xa1)*(0xff-0xa1+0x7f-0x40)
	        +FULL_SIZE_FONT_CODE[(int)c-32][0]-
		(FULL_SIZE_FONT_CODE[(int)c-32][0]<0x7f ? 0x40 : 0x62);
	    *dbuf++ = (cc / (0xff-0xa1) +0xa1)&0x7f;
	    *dbuf++ = ((cc % (0xff-0xa1)) +0xa1)&0x7f;
	    *dbuf++= 27;*dbuf++='(';*dbuf++='B';
	    return dbuf;
	  }
      *dbuf++ = FULL_SIZE_FONT_CODE[(int)c-32][1];
      *dbuf++ = FULL_SIZE_FONT_CODE[(int)c-32][0];
    }
  else
    *dbuf++ = c;
  return dbuf;
}

int BIG5_inputmethod(CHAR *sbuf,CHAR *dbuf,int len)
{

  int i,j,cc;
  CHAR *dd = dbuf;
  CHAR c;
  
  if (sbuf == NULL && dbuf == NULL && len == 0)
    {
      clear_inputmethod();
      parn = 0;
      return 0;
    }
  else if (sbuf == NULL && dbuf == NULL && len == -1)
  {
    mark_inputmethod("[BIG5]");
    parn = 0;
    clear_inputmethod();
    return 0;
  }
  
   
  for(i=0;i<len;i++)
    {
      c = *sbuf++;
      fprintf(debugfile,"%x ",c);

      if (parn == 5)
	{
	  if (c != 255)
	    {
	      *dbuf++ = c;
	      fprintf(debugfile,"%x\n",c);
	    }
	  else
	    {
	      parn = bakparn;
	      fprintf(debugfile,"End brace\n");
	    }
	  continue;
	}
      if (c <='9' && c >= '0')
	{
	  par = par*16+c-'0';
	  show_inputmethod(BIG5_0+c-'0',parn);
	  parn++;
	}
      else if (c <='F' && c >= 'A')
	{
	  par = par*16+c-'A'+10;
	  show_inputmethod(BIG5_A+c-'A',parn);
	  parn++;
	}
      else if ( c <= 'f' && c >= 'a')
	{
	  par = par*16+c-'A'+10;
	  show_inputmethod(BIG5_A + c-'a',parn);
	  parn++;
	}
      else if (c == '\b'|| c == 127)
	{
	  if (parn != 0)
	    {
	      parn--;
	      par /= 16;
	      show_inputmethod(0xa140,parn);
	    }
	  else
	    *dbuf++ = '\b';
	}
      else if ( c == 27 )
	{
	  if (parn != 0)
	    {
	      for(j=0;j<parn;j++)
		show_inputmethod(0xa140,j);
	      parn = 0;
	      par = 0;
	    }
	  else
	    *dbuf++ = 27;
	}
      else if (c == 255)
	{
	  bakparn = parn;
	  parn = 5;
	  fprintf(debugfile,"Enter brace\n");
	  continue;
	}
      else
	{
	  /* Full size font input */
	  if (isfull)
	    dbuf = addfull(dbuf,c);
	  else
	    *dbuf++ = c;
	}
      if (parn == 4)
	{
	  cc = tran_code(CODE_BIG5,par/256,par%256);
	  if (cc == 0xffff)
	    alert_inputmethod();
	  else
	    {
	      if (mule && ch_codesystem() == CODE_BIG5)
		{
		  int b1,b2;

		  b1 = par / 256;
		  b2 = par % 256;
		  cc = (b1-0xa1)*(0xff-0xa1+0x7f-0x40)+b2 - 
		             (b2 < 0x7f ? 0x40 : 0x62);
		  *dbuf++= 27;*dbuf++='$';*dbuf++='(';
		  if (par >= 0xc6a1)
		    *dbuf++ = '0';
		  else
		    *dbuf++ = '1';
		  *dbuf++ = cc / (0xff-0xa1)+ 0x21;
		  *dbuf++ = (cc % (0xff-0xa1))+0x21;
		  *dbuf++ = 27;*dbuf++='(';*dbuf++='B';
		}
	       else
		 {
		   *dbuf++ = par/256;
		   *dbuf++ = par % 256;
		 }
	     }
	   parn = par = 0;
	   for(i=0;i<4;i++)
	     show_inputmethod(0xa140,i);
	 }
     }
   return dbuf-dd;
 }

void Multiple_loadtable(char *name,int loc)
{
  FILE *def;
  WordMap m;
  int cc,i;
  
  def = fopen(name,"rb");
  if (def == NULL)
    {
      fprintf(debugfile,"Can't open %s\n",name);
      return ;
    }
  mtab[loc] = (MultipleTable *) malloc(sizeof(MultipleTable));
  if (mtab[loc] == NULL)
    return;
  fread(&(mtab[loc]->head),sizeof(InputHead),1,def);
  nowtab = mtab[loc];
  cc = 0;
  nowtab->num = 0;
  while(fread(&m,sizeof(WordMap),1,def))
    {
      if ((cc % 100) == 0)
	{
	  nowtab->num +=1000;
	  if (!cc)
	    nowtab->keymap=(WordMap *) malloc(sizeof(WordMap)*nowtab->num);
	  else
	    nowtab->keymap=(WordMap *) 
	              realloc(nowtab->keymap,sizeof(WordMap)*nowtab->num);
	}
      mtab[loc]->keymap[cc++] = m;
    }
  nowtab->num = cc;
  mtab[loc]->keymap = (WordMap *) realloc(nowtab->keymap,sizeof(WordMap)*nowtab->num);
  for(i=0;i<cc-1;i++)
    if (memcmp(nowtab->keymap[i].seqs,nowtab->keymap[i+1].seqs,5)>0)
      {
	fprintf(debugfile,"Broken multiple table (%d) file %s\n",loc,name);
	free(mtab[loc]);
	mtab[loc] = NULL;
	break;
      }
  fprintf(debugfile,"%d word loaded\n",cc);
}
  
void Multiple_display()
{
  int loc,st,found,max,min,i;

  ii = 0;
  found = 0;
  max = nowtab->num;
  min = 0;
  while(min <= max && !found)
    {
      ii++;
      loc = (max+min)/2;
      fprintf(debugfile,"%d\n",loc);
      st = memcmp(mbuf,nowtab->keymap[loc].seqs,5);
      if (st == 0)
	found = 1;
      else if (st < 0)
	max = loc-1;
      else
	min = loc+1;
    }
  if (!found)
    {
      clear_inputmethod();
      alert_inputmethod();
      fprintf(debugfile,"NOT FOUND\n");
      parn = 0;
      return;
    }
  else
    fprintf(debugfile,"FOUND\n");
  /* search the first match pattern */
  while((loc>=0)&&(memcmp(nowtab->keymap[loc].seqs,nowtab->keymap[loc-1].seqs,5)==0))
    loc--;
  for(i=0;i<10;i++)
    {
      fprintf(debugfile,"%d\n",i);
      if (memcmp(nowtab->keymap[loc+i].seqs,mbuf,5)==0)
	mloc[i] = loc+i;
      else
	break;
      slot_inputmethod(i,nowtab->keymap[loc+i].word.big5);
    }
  ii =i;
  parn = 6;
  fprintf(debugfile,"allocated\n");
}


int Multiple_inputmethod(CHAR *sbuf,CHAR *dbuf,int len)
{
  int i;
  CHAR *file,*dd;
  FILE *def;
  
  if (sbuf == NULL && dbuf == NULL && len == 0)
    {
       if (multi_init)
	 return 0;
       multi_init = 1;
       for(i=0;i<10;i++)
	 mtab[i] = NULL;
       file = getenv("MULTIPLE");
       if (file == NULL)
	 file = "/etc/multitab";


       def = fopen(file,"r");
       if (def != NULL)
	 {
	   char *bb;
	   int tloc;

	   while(fgets(pbuf,1024,def))
	     {
	       bb = pbuf;
	       while(isspace(*bb)&&*bb) bb++;
	       if (*bb <='9' && *bb >= '0')
		 {
		   tloc  = *bb-'1';
		   bb++;
		   while(isspace(*bb)&&*bb) bb++;
		   if (*bb)
		     {
		       char *be = bb+1;
		       while(!isspace(*be)&&*be) be++;
		       *be = 0;
		       Multiple_loadtable(bb,tloc);
		     }
		 }
	     }
	   fclose(def);
	 }
      return 0;
    }
   else if (dbuf == NULL && sbuf == NULL && len == -1)
     {
       if (nowtab)
	 mark_inputmethod(nowtab->head.mark);
       else
	 mark_inputmethod("[ERR ]");
       for(i=0;i<((parn <= 5)? parn:5);i++)
	 show_inputmethod(nowtab->head.cmap.CHKEY[nowtab->head.mapkey[mbuf[i]]],i);
       if (parn == 6)
	 parn = 5;
       return;
     }
  if (sbuf == NULL && dbuf == NULL && len > 0)
    {
      nowtab = mtab[len-1];
      if (nowtab)
	mark_inputmethod(nowtab->head.mark);
      else
	mark_inputmethod("[ERR ]");
      parn = 0;
      return 0;
    }
  else if (nowtab == NULL)
    {
      alert_inputmethod();
      return 0;
    }
  dd = dbuf;
  while(len--)
    {
      if (parn == 10)
	{
	  if (*sbuf != 255)
	    {
	      *dbuf++ = *sbuf++;
	    }
	  else
	    parn = bakparn;
	  continue;
	}
      if (parn < 6)
	{
	  switch(*sbuf)
	    {
	    case ' ':
	      if (parn == 0)
		{
		  *dbuf++ = ' ';
		  break;
		}
	      for(i=parn;i<5;i++)
		mbuf[i] = 255;
	      Multiple_display();

	      if (ii == 1)
		{
		  dbuf=add_inputmethod(nowtab->keymap[mloc[0]].word.big5,dbuf);
		  parn = 0;
		  clear_inputmethod();
		  clearslot_inputmethod();
		}
	      else
		{	      
		  alert_inputmethod();
		}

	      sbuf++;
	      continue;
	    case '\b':
	    case 127:
	      if (parn != 0)
		{
		  parn--;
		  show_inputmethod(0xa140,parn);
		  mbuf[parn] = 255;
		}
	      else
		*dbuf++ = *sbuf;
	      break;
	    case 255:
	      bakparn = parn;
	      parn = 10;
	      break;
	    case 27:
	      clear_inputmethod();
	      parn = 0;
	      break;
	    default:
	      if (nowtab->head.mapkey[(int)*sbuf]!= 255 && parn < 5)
		{
		  show_inputmethod(nowtab->head.cmap.CHKEY[(int)nowtab->head.mapkey[*sbuf]],parn);
		  mbuf[parn++] = nowtab->head.mapkey[(int)*sbuf];
		}
	      else
		*dbuf++ = *sbuf;
	      break;
	    }
	}
      if (parn == 6)
	{
	  if (*sbuf == 27)
	    {
	      clearslot_inputmethod();
	      parn = 0;
	    }
	  else if (*sbuf>='1' && *sbuf<='9')
	    {
	      if (*sbuf-'1' < ii)
		{
		  dbuf = add_inputmethod(nowtab->keymap[mloc[*sbuf-'1']].word.big5,dbuf);
		}
	      else
		{
		  dbuf = add_inputmethod(nowtab->keymap[mloc[0]].word.big5,dbuf);
		  len++;sbuf--;
		}
	    }
	  else
	    {
	      len++;sbuf--;
	      dbuf = add_inputmethod(nowtab->keymap[mloc[0]].word.big5,dbuf);
	    }
	  clear_inputmethod();
	  clearslot_inputmethod();
	  parn = 0;
	}
      sbuf++;
    }
  return dbuf - dd;
}
  

