#include <stdio.h>
#include "portable.h"
#include "font.h"
#include "chinese.h"

static unsigned char isCached[MAX_FONT_CODE/8+1];
static int Max_Cache=-1;
static FontCache *fCache;
static int NextLoc=-1;
static int count,hit,font_number;
/*
   description:
      initial the Font cache system
*/


void FontCache_init(int mcache)
{
  int i;
  char *buffer;

  for(i=0;i<MAX_FONT_CODE/8+1;i++)
    {
      isCached[i]=0;
    }

  /* if re initialize,free the Font cache buffer */
  if (fCache != NULL)
    {
      free(fCache);
    }

  fCache = (FontCache *) malloc(sizeof(FontCache)*(mcache+1));
  if (fCache == NULL|| buffer==NULL)
    {
      SYSERR("Can't allocate buffer for font cache,disable it");
      Max_Cache = 0;
      return;
    }

  Max_Cache = mcache;

  for(i=0;i<mcache;i++)
    {
      fCache[i].code = -1;
      fCache[i].bitmap = NULL;
    }

  NextLoc=font_number=0;
}

/*
   description:
       Search font in 'fCache' by binary search
   limit:
      The alogithm is something ineffctive.
*/

static FontCache *FontCache_search(int code,int w,int h)
{
  int l,r,i;

#ifdef DISABLE_CACHE
  if (code < Max_Cache)
    return fCache+code;
  else
    return NULL;
#endif
  l = 0;r = font_number;
  while(l<=r)
    {
      i = (l + r)/2;
      if (fCache[i].code == code)
	{
	    l = i;
	    while((fCache[i].w != w)||(fCache[i].h != h))
	      {
		  i--;
		  if (i<0 || fCache[i].code != code)
		    {
			i = l+1;
			while((fCache[i].w != w)||(fCache[i].h != h))
			  {
			      i++;
			      if (fCache[i].bitmap == NULL)
				return NULL;
			  }
			return fCache+i;
		    }
	      }
	    return fCache+i;
	}
      else if (fCache[i].code<code)
	{
	  l = i + 1;
	}
      else
	{
	  r = i - 1;
	}
    }
  return NULL;
}
/*
   description :
       check if the font is already in font cache.if yes,return the expanded
       font to caller.Otherwise return NULL.
   limit:
       you shouldn't use argument code > MAX_FONT_CODE
*/

#define InCacheBuffer(code) \
  (isCached[code/8] &(1<<(code%8)))

#define SetCacheBuffer(code) \
  isCached[code/8] |= (1<<(code%8))

#define ClearCacheBuffer(code) \
  isCached[code/8] &= ~(1<<(code%8))

char *FontCache_find(int code,int *type,int w,int h)
{
  unsigned char c;
  int t;
  FontCache *f;

  
  *type = SOFTWARE;
#ifdef DISABLE_CACHE
  if (code >= Max_Cache)
    return NULL;
#endif
  c = InCacheBuffer(code);
  count++;
  if (count == 500)
    {
      count /= 2;
      hit /=2;
    }
  if (c)
    {
      f = FontCache_search(code,w,h);
      if (f == NULL)
	{
	  SYSERR("Font cache is broken,fresh force");
	  FontCache_init(Max_Cache);
	  return NULL;
	}
      hit++;
      f->access++;
      if (f->code != code)
	{
	  return NULL;
	}
      return f->bitmap;
    }
  return NULL;
}

/*
   description:
       Add a bitmap to Font cache.Use least using alogithm
*/

int FontCache_add(int code,char *bitmap,int w,int h)
{
  int i,j,c,min,minf,fontlen;
  char *data;

#ifdef DISABLE_CACHE
  if (code >= Max_Cache)
    return 0;
#endif

  c = InCacheBuffer(code);
  if (c)
    {
      return 0;
    }
  SetCacheBuffer(code);
  fontlen = mon_fontsize(w,h);

#ifndef DISABLE_CACHE
  if (font_number == Max_Cache)
    {
      /* find a font to replaced */
      minf = 0;
      min = fCache[0].access;
      for(i=0;i<Max_Cache;i++)
	{
	  if (min > fCache[i].access)
	    {
	      minf = i;
	      min = fCache[i].access;
	    }
	}

      ClearCacheBuffer(fCache[minf].code);
      data = fCache[minf].bitmap;
      for(i=minf;i<Max_Cache-1;i++)
	fCache[i] = fCache[i+1];
      free(data);
      fCache[i].bitmap = NULL;
      fCache[i].w = w;
      fCache[i].h = h;
      font_number--;
    }

  for(i=0;i<font_number;i++)
    if (code<=fCache[i].code)
      break;

  if (fCache[i].code == code)
    {
      return 0;
    }
  j=font_number-1;
  data = fCache[j+1].bitmap;
  while(j>=i)
    {
      fCache[j+1] = fCache[j];
      j--;
    }
  fCache[i].bitmap = malloc(fontlen);
#else
  i = code;
  if (fCache[i].bitmap == NULL)
    fCache[i].bitmap = (char *) malloc(fontlen);
#endif
  fCache[i].code = code;
  fCache[i].access = 0;
  fCache[i].h = h;
  fCache[i].w = w;
  if (fCache[i].bitmap==NULL)
    SYSERR("Out of memory");
	
  memcpy(fCache[i].bitmap,bitmap,fontlen);
  font_number++;
  return 1;
}
    
      
FontCache_list()
{
  int i;

  for(i=0;i<font_number;i++)
    {
      printf("%d %d \n",i,fCache[i].code);
    }
}

FontCache_state()
{
  printf("hit rate = %lf  and %d fonts cached \n",
	 hit/(double) count,font_number);
}

