#!/bin/sh
# This is the UNINSTALL script for the apcupsd package...

if [ `ps x | gawk '{ if (($5 == "/sbin/apcupsd") || \
	($5 == "/usr/sbin/apcupsd") || \
	($5 == "apcupsd")) print $1 }'` ]; then
	printf "Stopping a running version of "\"apcupsd\"".\n"
	kill `ps x | gawk '{ if (($5 == "/sbin/apcupsd") || \
		($5 == "/usr/sbin/apcupsd") || \
		($5 == "apcupsd")) print $1 }'`
	if [ -f /var/run/apcupsd.pid ]; then
		rm -f /var/run/apcupsd.pid
	fi
fi

if [ -d /etc/rc.d/init.d ]; then
	echo "removing: redhat installation"
	echo "removing: /etc/rc.d/init.d/apcups"
	rm -f /etc/rc.d/init.d/apcups
	echo "removing: /etc/rc.d/rc[1235].d/S20apcups"
	rm -f /etc/rc.d/rc1.d/S20apcups
	rm -f /etc/rc.d/rc2.d/S20apcups
	rm -f /etc/rc.d/rc3.d/S20apcups
	rm -f /etc/rc.d/rc5.d/S20apcups
	echo "removing: /etc/rc.d/rc[016].d/K20apcups"
	rm -f /etc/rc.d/rc0.d/K20apcups
	rm -f /etc/rc.d/rc1.d/K20apcups
	rm -f /etc/rc.d/rc6.d/K20apcups
fi

if [ -d /sbin/init.d ]; then
	echo "removing: suse installation"
	echo "System configurations files for apcupsd need to be updated."
	if [ "`grep -i "START_APCUPSD" /etc/rc.config`" = "START_APCUPSD=yes" ]; then
		echo "Have been here before, change START_APCUPSD=yes"
		echo "to START_APCUPSD=no or delete lines"
	fi
	echo "removing: /sbin/init.d/apcups"
	rm -f /sbin/init.d/apcups
	echo "removing: /sbin/init.d/rc[12].d/S20apcups"
	rm -f /sbin/init.d/rc1.d/S20apcups
	rm -f /sbin/init.d/rc2.d/S20apcups
	echo "removing: /sbin/init.d/rc[12].d/K20apcups"
	rm -f /sbin/init.d/rc1.d/K20apcups
	rm -f /sbin/init.d/rc2.d/K20apcups
fi

if [ -d /etc/init.d ]; then
	if [ -f /etc/init.d/shutdown ]; then
		echo "removing: unifix installation"
		echo "/etc/SERVICES needs adjustment"
	else
		echo "removing: debian installation"
		echo "removing: /etc/init.d/apcups"
		rm -f /etc/init.d/apcups
		echo "removing: /etc/rc[12345].d/S20apcups"
		rm -f /etc/rc1.d/S20apcups
		rm -f /etc/rc2.d/S20apcups
		rm -f /etc/rc3.d/S20apcups
		rm -f /etc/rc4.d/S20apcups
		rm -f /etc/rc5.d/S20apcups
		echo "removing: /etc/rc[016].d/K20apcups"
		rm -f /etc/rc0.d/K20apcups
		rm -f /etc/rc1.d/K20apcups
		rm -f /etc/rc6.d/K20apcups
	fi
fi

echo "removing: /etc/apcupsd.conf"
rm -f /etc/apcupsd.conf
echo "removing: /etc/apcupsd.status"
rm -f /etc/apcupsd.status
echo "removing: /var/log/apcupsd.log"
rm -f /var/log/apcupsd.log 
echo "removing: /sbin/apcupsd"
rm -f /sbin/apcupsd
echo "removing: /sbin/powersc"
rm -f /sbin/powersc
echo "removing: /usr/man/man8/apcupsd.8.gz"
rm -f /usr/man/man8/apcupsd.8.gz

printf "Done... I hope there were no problems...\n"
exit 0
