/* afio.h  defines for afio. */

#ifdef	SYSTIME
#include <sys/time.h>
#else /* SYSTIME */
#include <time.h>
#endif /* SYSTIME */

#ifdef	CTC3B2
#include <sys/vtoc.h>
#include <sys/ct.h>
#endif /* CTC3B2 */

#ifdef MYTEMPNAM
#include <sys/file.h>
#endif

#ifdef USESHMEM
#include <sys/ipc.h>
#include <sys/shm.h>

#define	NUMSHKEYS	20
#define	SHMEMSIZE	262144	/* 2^18 (dev3b1) */
#endif

/* done writing to the archive */
#define	FALSE	0
#define	TRUE	1
#define	NOTDONE	0
#define	DONE	1
#define	NODIE	0
#define	DIE	1

/* KH */
#define MEMFD 10000
#define ZIPFD 10001
extern int zipfdfd;

/* flags for the st_rdev field of regular files */
 /* file is not compressed, ignore any .z extension */
#define RDEV_NOTCOMPR 1
 /* file is a control file */
#define RDEV_ISCONTROL 2

/*
   An archive entry is a control file if it is a regular file and
   if the ISCONTROL flag is set.  The filename is not important.
*/
#define ISCONTROL(sb) ((((sb)->sb_mode & S_IFMT) == S_IFREG)&&((sb)->sb_rdev & RDEV_ISCONTROL))

/* pseudo filename for control files */
#define CONTROLNAME "CONTROL_FILE"

/* label value if no label given */
#define NOLABEL "no_label"

/*
 * Address link information base.
 */
#define	linkhash(ino)	\
	(linkbase + ((ino) & 0xffff) % nel(linkbase))

/*
 * Mininum value.
 */
#define	min(one, two)	\
	(one < two ? one : two)

/*
 * Number of array elements.
 */
#define	nel(a)		\
	(sizeof(a) / sizeof(*(a)))

/*
 * Remove a file or directory.
 */
#define	afremove(name, asb) \
	(((asb)->sb_mode & S_IFMT) == S_IFDIR ? rmdir(name) : unlink(name))

/*
 * Swap bytes.
 */
#define	swab(n)		\
	((((ushort)(n) >> 8) & 0xff) | (((ushort)(n) << 8) & 0xff00))

/*
 * Cast and reduce to unsigned short.
 */
#define	ush(n)		\
	(((ushort) (n)) & 0177777)

/*
 * Definitions.
 */
#define	reg	register	/* Convenience */
#define	uint	unsigned int	/* Not always in types.h */
#define	ushort	unsigned short	/* Not always in types.h */
#define	BLOCK	5120		/* Default archive block size */
#define	FSBUF	(8*1024)	/* Filesystem buffer size */
#define	H_COUNT	10		/* Number of items in ASCII header */

/* old ASCII format */
#define	H_PRINT	"%06o%06o%06o%06o%06o%06o%06o%011lo%06o%011lo"
/* H_SCAN is obsolete, replaced by PH_SCAN to be more portable. */
#define	H_SCAN	"%6ho%6ho%6ho%6ho%6ho%6ho%6ho%11lo%6o%11lo"
#define PH_SCAN  "%6lo%6lo%6lo%6lo%6lo%6lo%6lo%11lo%6o%11lo"

/*
Below is a handy piece of ASCII art which can be used to decode old
ASCII format headers.

|23456|23456|23456|23456|23456|23456|23456|23456|23456789ab|23456|23456789ab|-
|  hdr|  dev|  ino| mode|  uid|  gid|nlink| rdev|     mtime|nmlen|      size|n


*/


/* extended ASCII format */
#define	H_PRINT2  "%06o%011lo%06o%06o%06o%06o%06o%011lo%06o%011lo"
#define PH_SCAN2  "%6lo%11lo%6lo%6lo%6lo%6lo%6lo%11lo%6o%11lo"


typedef struct {
long unsigned int PSt_dev;
long unsigned int PSt_ino;
long unsigned int PSt_mode;
long unsigned int PSt_uid;
long unsigned int PSt_gid;
long unsigned int PSt_nlink;
long unsigned int PSt_rdev;
long unsigned int PSt_mtime;
long unsigned int PSt_size;
} PStat;

#define	H_STRLEN 70		/* old ASCII header string length */
#define	M_ASCII "070707"	/* old ASCII magic number */
#define	H_STRLEN2 75		/* extended ASCII header string length */
#define	M_ASCII2 "070717"	/* extended ASCII magic number */
#define	M_BINARY 070707		/* Binary magic number */
#define	M_STRLEN 6		/* ASCII magic number length */
#define	NULLDEV	-1		/* Null device code */
#define	NULLINO	0		/* Null inode number */
#define	PATHELEM 256		/* Pathname element count limit */
#define	PATHSIZE 1024		/* Pathname length limit */
#define	S_IFSHF	12		/* File type shift (shb in stat.h) */
#define	S_IPERM	07777		/* File permission bits (shb in stat.h) */
#define	S_IPEXE	07000		/* Special execution bits (shb in stat.h) */
#define	S_IPOPN	0777		/* Open access bits (shb in stat.h) */
#define	STDIN	0		/* Standard input file descriptor */
#define	STDOUT	1		/* Standard output file descriptor */
#define	TTY	"/dev/tty"	/* For volume-change queries */

#ifndef PRG_COMPRESS
#define PRG_COMPRESS "compress"
#endif

/*
 * Some versions of the portable "C" compiler (PCC) can't handle
 * pointers to functions returning void.
 */
#ifdef	VOIDFIX
#define	VOIDFN	void		/* Expect "void (*fnptr)()" to work */
#else /* VOIDFIX */
#define	VOIDFN	int		/* Avoid PCC "void (*fnptr)()" bug */
#endif /* VOIDFIX */

/*
 * Trailer pathnames. All must be of the same length.
 */
#define	TRAILER	"TRAILER!!!"	/* Archive trailer (cpio compatible) */
#define	TRAILZ	11		/* Trailer pathname length (including null) */

/*
 * Open modes; there is no <fcntl.h> with v7 UNIX.
 */
#ifdef HAVEFCNTL
#include <fcntl.h>
#else
#define	O_RDONLY 0		/* Read-only */
#define	O_WRONLY 1		/* Write-only */
#define	O_RDWR	2		/* Read/write */
#endif
/*
 * V7 and BSD UNIX use old-fashioned names for a couple of
 * string functions.
 */
#ifdef	INDEX
#define	strchr	index		/* Forward character search */
#define	strrchr	rindex		/* Reverse character search */
#endif /* INDEX */

/*
 * Some compilers can't handle void casts.
 */
#ifdef	NOVOID
#define	VOID			/* Omit void casts */
#else /* NOVOID */
#define	VOID	(void)		/* Quiet lint about ignored return values */
#endif /* NOVOID */

/*
 * Adb is more palatable when static functions and variables are
 * declared as globals. Lint gives more useful information when
 * statics are truly static.
 */
#ifdef	lint
#define	STATIC	static		/* Declare static variables for lint */
#else /* lint */
#define	STATIC			/* Make static variables global for adb */
#endif /* lint */

/*
 * Simple types.
 */
typedef struct group Group;	/* Structure for getgrgid(3) */
typedef struct passwd Passwd;	/* Structure for getpwuid(3) */
typedef struct tm Time;		/* Structure for localtime(3) */

#ifdef	S_IFLNK
/*
 * File status with symbolic links. Kludged to hold symbolic
 * link pathname within structure.
 */
typedef struct
{
  struct stat sb_stat;
  char sb_link[PATHSIZE];
} Stat;

#define	STAT(name, asb)		stat(name, &(asb)->sb_stat)
#define	FSTAT(fd, asb)		fstat(fd, &(asb)->sb_stat)
#define	LSTAT(name, asb)	lstat(name, &(asb)->sb_stat)
#define	sb_dev		sb_stat.st_dev
#define	sb_ino		sb_stat.st_ino
#define	sb_mode		sb_stat.st_mode
#define	sb_nlink	sb_stat.st_nlink
#define	sb_uid		sb_stat.st_uid
#define	sb_gid		sb_stat.st_gid
#define	sb_rdev		sb_stat.st_rdev
#define	sb_size		sb_stat.st_size
#define	sb_atime	sb_stat.st_atime
#define	sb_mtime	sb_stat.st_mtime
#define	sb_ctime	sb_stat.st_ctime
#define	sb_blksize	sb_stat.st_blksize
#define	sb_blocks	sb_stat.st_blocks
#else /* !S_IFLNK */
/*
 * File status without symbolic links.
 */
typedef struct stat Stat;
#define	STAT(name, asb)		stat(name, asb)
#define	FSTAT(fd, asb)		fstat(fd, asb)
#define	LSTAT(name, asb)	stat(name, asb)
#define	sb_dev		st_dev
#define	sb_ino		st_ino
#define	sb_mode		st_mode
#define	sb_nlink	st_nlink
#define	sb_uid		st_uid
#define	sb_gid		st_gid
#define	sb_rdev		st_rdev
#define	sb_size		st_size
#define	sb_atime	st_atime
#define	sb_mtime	st_mtime
#define	sb_ctime	st_ctime
#endif /* !S_IFLNK */

/*
 * Binary archive header (obsolete).
 */
typedef struct
{
  short b_dev;			/* Device code */
  ushort b_ino;			/* Inode number */
  ushort b_mode;		/* Type and permissions */
  ushort b_uid;			/* Owner */
  ushort b_gid;			/* Group */
  short b_nlink;		/* Number of links */
  short b_rdev;			/* Real device */
  ushort b_mtime[2];		/* Modification time (hi/lo) */
  ushort b_name;		/* Length of pathname (with null) */
  ushort b_size[2];		/* Length of data */
} Binary;

/*
 * Child process structure.
 */
typedef struct child
{
  struct child *c_forw;		/* Forward link */
  int c_pid;			/* Process ID */
  int c_flags;			/* Flags (CF_) */
  int c_status;			/* Exit status */
} Child;

/*
 * Child process flags (c_flags).
 */
#define	CF_EXIT	(1<<0)		/* Exited */

/*
 * Hard link sources. One or more are chained from each link
 * structure.
 */
typedef struct name
{
  struct name *p_forw;		/* Forward chain (terminated) */
  struct name *p_back;		/* Backward chain (circular) */
  char *p_name;			/* Pathname to link from */
} Path;

/*
 * File linking information. One entry exists for each unique
 * file with with outstanding hard links.
 */
typedef struct link
{
  struct link *l_forw;		/* Forward chain (terminated) */
  struct link *l_back;		/* Backward chain (terminated) */
  dev_t l_dev;			/* Device */
  ino_t l_ino;			/* Inode */
  ino_t l_ino_ar;		/* Inode nr we will put in the archive */
  ushort l_nlink;		/* Unresolved link count */
  time_t l_mtime;		/* Modification time */
  ushort l_mode;               /* mode */
  off_t l_size;			/* Length */
  Path *l_path;			/* Pathname(s) to link from */
} Link;


/*
 * Internal functions.
 */
VOIDFN copyin ();
VOIDFN copyout ();
void compressfile ();
int dirchg ();
int dirmake ();
int dirneed ();
void fatal ();
void goodbye ();
VOIDFN in ();
void inalloc ();
int inascii ();
int inavail ();
int inbinary ();
int indata ();
int inentry ();
int infill ();
int inhead ();
int inhead2 ();
int inread ();
int inskip ();
int inswab ();
int lineget ();
void linkalso ();
Link *linkfrom ();
void linkleft ();
Link *linkto ();
#ifndef MEMCPY
char *memcpy ();
#endif
char *memget ();
char *memstr ();
#ifndef MKDIR
int mkdir ();
#endif
void nameadd ();
int namecmp ();
int nameopt ();
void next ();
void nextask ();
void nextclos ();
int nextopen ();
int openin ();
int openotty ();
int openqtty ();
int options ();
VOIDFN out ();
void outalloc ();
uint outavail ();
int outdata ();

void outdatazip (); /* added KH */
void handler();     /* added KH */
void waitforgzip();     /* added KH */
void outdatamem (); /* added KH */
void memreset(); /* added KH */
int memread(char *buf,int count); /* added KH */
void memfree(); /* added KH */
int readcompexts(); /* added KH */
int nameaddfile(); /* added KH */

void outeof ();
void outflush ();
void outhead ();
void outhead2 ();
void outpad ();
void outwait ();
void outwrite ();
VOIDFN pass ();
void passdata ();
int passitem ();
int pipechld ();
int pipeopen ();
void pipewait ();
void prsize ();
VOIDFN readcheck ();
#ifndef MKDIR
int rmdir ();
#endif
#if !defined (linux) && !defined(__FreeBSD__)
VOIDFN (*signal ())();
#endif
     int fswrite ();
#ifdef USESHMEM
     char *shmemalloc ();
     void shmemfree ();
#endif
     char *syserr ();
     VOIDFN toc ();
     void tocentry ();
     void tocmode ();
     void usage ();
     void verify ();
     int warn ();
     int warn_nocount ();
     int warnarch ();
     int writedisk ();
     int xfork ();
     void xpause ();
     int xwait ();
     void mail(char *who,int vol,char *archive);

int writeall();
int incheckentry();
int openincheck();
void mayberewind();

extern	void clear_args(void);
extern  void add_arg(char *arg);
extern  char *compress_arg_list[];

extern short lflag;
extern short hflag;

extern int gzipfactor;
extern off_t maxmem;
extern long compthreshold;
extern int ignoreslash;
extern short Zflag;
extern int arfd;

extern int forceZflag;
extern char *compressprog;
extern int compressargs;
extern int rewindfd;
extern char *ignorewarnings;

/* Note for porters: we use the ulonglong type in calculations with
   integers which should be large enough to hold the size of 1 tape
   (if -s option used) or the size of the entire archive.  With >2GB
   tapes appearing, the off_t type (32 bit signed on Linux), which was
   previously used, was getting too small.

   long long is supported by many compilers as a >=64 bit integer, so
   we use it to ensure correct byte position reporting and tape change
   operations for >2GB tapes.

   Alternatives in the ifs below: double is 64 bit floating point on
   many compilers, which gives us enough bits in the mantissa part to
   go to really large (2GB>) integer numbers without loss of accuracy.
   If double is 32 bits then it will loose accuracy to soon and a
   plain long (assuming plain long is 32 bits) will have to be used to
   go to 2GB reliably.  A long double would be another option, if that
   is bigger than a double.  
*/

#if 1

typedef  unsigned long long ulonglong;

#else

#if 1

typedef double ulonglong;
/* also need to change a % into an fmod() somewhere in afio.c
   if we use this one. */

#else

typedef  unsigned long ulonglong;

#endif

#endif

ulonglong optsize ();
void update_aruntil();
