/***********************************************************************
  splcc: split text file by character code
                                    Copyright (C) 1998, Takuya NAKAYAMA
 ***********************************************************************/
#include <stdio.h>
#include "chartype.h"

typedef enum charcode_ {
    HIRA,
    KATA,
    KANJI,
    SEP,
    ETC
} CharCode;

int main(void)
{
    CharCode code, new_code;
    Char x;
    int ff;

    code = SEP;

    while (1) {
	x = fgetC(stdin);
	if (x.d == 0x0000) break; /* EOF */
	if (x.d == 0xa1bc) /*  */
	    new_code = code;
	else if (is_kanaH(x.d)) { /* ʿ̾ */
	    new_code = HIRA;
	} else if (is_kanaK(x.d)) { /* Ҳ̾ */
	    new_code = KATA;
	} else if (is_space(x.d) || is_kakko(x.d) || is_kokka(x.d) ||
		   is_TEN(x.d) || x.d == 0xa8ac) {
	    /*   */
	    new_code = SEP;
	} else if (is_EUC(x.d)) { /*  */
	    new_code = KANJI;
	} else {
	    /* ascii */
	    if (x.c.h == 0x0a) {
		ff = 1;
		new_code = code;
	    } else if (x.d <= 0x2000 ||
		x.c.h == 0x22 || /* "" */
		x.c.h == 0x27 || /* ' */
		x.c.h == 0x2c    /* , */) {
		new_code = SEP;
	    } else {
		new_code = ETC;
	    }
	}
	/*  for debug
	printf ("[%x =  %x . %x] code=%d(%d) ",
		x.d, x.c.h, x.c.l, new_code, ff);
	code = new_code; fputC(x, stdout); fputc('\n', stdout);
	ff = 0;
	*/
	if (code != new_code) {
	    if (code != SEP) {
		fputc('\n', stdout);
	    }
	} else if (code == ETC && ff > 0) {
	    fputc('\n', stdout);
	}
	code = new_code;
	if (code != SEP && ff == 0) {
	    fputC(x, stdout);
	} else {
	    ff = 0;
	}
    }
    
    return 0;
}
