/*
 * Copyright (c) 1997, 1998  Motoyuki Kasahara
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

/*
 * This program requires the following Autoconf macros:
 *   AC_C_CONST
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>

/*
 * Do wildcard pattern matching.
 * In the pattern, the following characters have special meaning.
 * 
 *   `*'    matches any sequence of zero or more characters.
 *   '\x'   a character following a backslash is taken literally.
 *          (e.g. '\*' means an asterisk itself.)
 *
 * If `pattern' matches to `string', 1 is returned.  Otherwise 0 is
 * returned.
 */
int
match_wildcard(pattern, string)
    const char *pattern;
    const char *string;
{
    const char *pp = pattern;
    const char *sp = string;

    while (*pp != '\0') {
	if (*pp == '*') {
	    pp++;
	    if (*pp == '\0')
		return 1;
	    while (*sp != '\0') {
		if (*sp == *pp && match_wildcard(pp, sp))
		    return 1;
		sp++;
	    }
	    return 0;
	} else {
	    if (*pp == '\\' && *(pp + 1) != '\0')
		pp++;
	    if (*pp != *sp)
		return 0;
	}
	pp++;
	sp++;
    }

    return (*sp == '\0');
}


