<!DOCTYPE style-sheet PUBLIC "-//James Clark//DTD DSSSL Style Sheet//EN" [
<!ENTITY docbook.dsl PUBLIC "-//Norman Walsh//DOCUMENT DocBook HTML Stylesheet//EN" CDATA DSSSL>
]>

<style-sheet>
<style-specification id="docbook-plain" use="docbook">
<style-specification-body>

(define (qanda-defaultlabel)
  (normalize "number"))

(element qandaset
  (let ((title (select-elements (children (current-node)) 
				(normalize "title"))))
    (make element gi: "DIV"
	  attributes: (list (list "CLASS" (gi)))
	  (process-node-list title)
	  (process-qanda-toc)
	  (process-qanda))))

(element (qandaset title)
  (let* ((enclsect (ancestor-member (current-node)
				    (list (normalize "section")
					  (normalize "simplesect")
					  (normalize "sect5")
					  (normalize "sect4")
					  (normalize "sect3")
					  (normalize "sect2")
					  (normalize "sect1")
					  (normalize "refsect3")
					  (normalize "refsect2")
					  (normalize "refsect1"))))
	 (sectlvl (SECTLEVEL enclsect))
	 (htmlgi  (string-append "H" (number->string (+ sectlvl 1)))))
    (make element gi: htmlgi
	  (process-children))))

(element qandadiv
  (let ((title (select-elements (children (current-node)) 
				(normalize "title"))))
    (make sequence
      (make element gi: "DT"
	    (process-node-list title))
      (make element gi: "DD"
	    (make element gi: "P"
		  (empty-sosofo))   ;; force spacing
	    (process-qanda)))))

(element (qandadiv title)
  (let* ((hnr     (hierarchical-number-recursive (normalize "qandadiv")
						 (current-node)))
	 (number  (let loop ((numlist hnr) (number "") (sep ""))
		    (if (null? numlist)
			number
			(loop (cdr numlist) 
			      (string-append number
					     sep
					     (number->string (car numlist)))
			      ".")))))
    (make sequence
      (make element gi: "B"
	    (make element gi: "A"
		  attributes: (list (list "NAME" (element-id 
						  (parent (current-node)))))
		  (empty-sosofo))
	    (literal number ". ")
	    (process-children)))))

(define (process-qanda #!optional (node (current-node)))
  (let* ((preamble (node-list-filter-by-not-gi 
		    (children node)
		    (list (normalize "title")
			  (normalize "qandadiv") 
			  (normalize "qandaentry"))))
	 (divs     (node-list-filter-by-gi (children node)
					   (list (normalize "qandadiv"))))
	 (entries  (node-list-filter-by-gi (children node)
					   (list (normalize "qandaentry"))))
	 (inhlabel (inherited-attribute-string (normalize "defaultlabel")))
	 (deflabel (if inhlabel inhlabel (qanda-defaultlabel))))
    (make sequence
      (process-node-list preamble)
      (make element gi: "DL"
	    attributes: '(("CLASS" "QANDA")
			  ("COMPACT" "COMPACT"))
	    (process-node-list divs)
	    (process-node-list entries)))))

(element qandaentry
  ;; In order to get the "right" HTML out of this, we have to be a
  ;; bit tricky. We need the first child of the question, the
  ;; rest of the question, the first child of the answer, the rest
  ;; of the answer, the labels, etc.
  (let* ((qaent        (current-node))
	 (inhlabel     (inherited-attribute-string (normalize "defaultlabel")))
	 (deflabel     (if inhlabel inhlabel (qanda-defaultlabel)))

	 (question     (select-elements (children qaent) 
					(normalize "question")))
	 (qlabel       (select-elements (children question) 
					(normalize "label")))
	 (qchildren    (node-list-filter-by-not-gi (children question)
						   (list (normalize "label"))))
	 (qfchild      (node-list-first qchildren))
	 (qrchildren   (node-list-rest qchildren))

	 (answer       (select-elements (children qaent) 
					(normalize "answer")))
	 (alabel       (select-elements (children answer) 
					(normalize "label")))
	 (achildren    (node-list-filter-by-not-gi (children answer)
						   (list (normalize "label"))))
	 (afchild      (node-list-first achildren))
	 (archildren   (node-list-rest achildren))
    
	 (hnr          (hierarchical-number-recursive (normalize "qandadiv")
						      qaent))
	 (hnumber      (let loop ((numlist hnr) (number "") (sep ""))
			 (if (null? numlist)
			     number
			     (loop (cdr numlist) 
				   (string-append number
						  sep
						  (number->string 
						   (car numlist)))
				   "."))))
	 (cnumber     (child-number qaent))
	 (number      (if (equal? hnumber "")
			  (number->string cnumber)
			  (string-append hnumber "." 
					 (number->string cnumber)))))
    (make sequence
      ;; output the question label
      (make element gi: "DT"
	    (make element gi: "B"
		  (if (node-list-empty? qlabel)
		      (cond
		       ((equal? deflabel (normalize "qanda"))
			(literal "Q: "))
		       ((equal? deflabel (normalize "number"))
			(literal number "xxx. "))
		       (else (empty-sosofo)))
		      (process-node-list qlabel))))
      (make element gi: "DD"
	    ;; output the content of the first question element
	    (make element gi: "B"
		  (process-node-list (children qfchild)))
	    ;; output the rest of the question
	    (process-node-list qrchildren)
	    ;; output the answer label and the content of the first
	    ;; answer element
	    (make element gi: "P"
		  (make element gi: "B"
			(if (node-list-empty? alabel)
			    (if (equal? deflabel (normalize "qanda"))
				(literal "A: ")
				(empty-sosofo))
			    (process-node-list alabel)))
		  (process-node-list (children afchild)))
	    ;; output the content of the answer
	    (process-node-list archildren)))))

;(element question
;  (let* ((inhlabel (inherited-attribute-string (normalize "defaultlabel")))
;	 (deflabel (if inhlabel inhlabel (qanda-defaultlabel)))
;	 (label    (attribute-string (normalize "label")))
;	 (hnr      (hierarchical-number-recursive (normalize "qandadiv")
;						  (current-node)))
;	 (hnumber  (let loop ((numlist hnr) (number "") (sep ""))
;		     (if (null? numlist)
;			 number
;			 (loop (cdr numlist) 
;			       (string-append number
;					      sep
;					      (number->string (car numlist)))
;			       "."))))
;	 (cnumber  (child-number (parent (current-node))))
;	 (number   (string-append hnumber 
;				  "."
;				  (number->string cnumber)))
;	 (chlist   (children (current-node)))
;	 (firstch  (node-list-first chlist))
;	 (restch   (node-list-rest chlist)))
;    (make sequence
;      (make element gi: "DT"
;	    (make element gi: "B"
;		  (cond
;		   ((equal? deflabel (normalize "qanda"))
;		    (literal "Q: "))
;		   ((equal? deflabel (normalize "label"))
;		    (literal label " "))
;		   ((equal? deflabel (normalize "number"))
;		    (literal number ". "))
;		   (else (empty-sosofo)))))
;      (make element gi: "DD"
;	    (make element gi: "B"
;		  (make element gi: "A"
;			attributes: (list (list "NAME" (element-id)))
;			(process-node-list (children firstch))))
;	    (process-node-list restch)))))
;
;(element answer
;  (let* ((inhlabel (inherited-attribute-string (normalize "defaultlabel")))
;	 (deflabel (if inhlabel inhlabel (qanda-defaultlabel)))
;	 (label    (attribute-string (normalize "label")))
;	 (chlist   (children (current-node)))
;	 (firstch  (node-list-first chlist))
;	 (restch   (node-list-rest chlist)))
;    (make element gi: "DD"
;	  (make element gi: "P"
;		(cond
;		 ((equal? deflabel (normalize "qanda"))
;		  (make element gi: "B"
;			(literal "A: ")))
;		 ((equal? deflabel (normalize "label"))
;		  (make element gi: "B"
;			(literal label)))
;		 (else (empty-sosofo)))
;		(process-node-list (children firstch)))
;	  (process-node-list restch))))

;; ========================================================================

(define (process-qanda-toc #!optional (node (current-node)))
  (let* ((divs     (node-list-filter-by-gi (children node)
					   (list (normalize "qandadiv"))))
	 (entries  (node-list-filter-by-gi (children node)
					   (list (normalize "qandaentry"))))
	 (inhlabel (inherited-attribute-string (normalize "defaultlabel")))
	 (deflabel (if inhlabel inhlabel (qanda-defaultlabel))))
    (make element gi: "DL"
	  (with-mode qandatoc
	    (process-node-list divs))
	  (with-mode qandatoc
	    (process-node-list entries)))))

(mode qandatoc
  (element qandadiv
    (let ((title (select-elements (children (current-node))
				  (normalize "title"))))
      (make sequence
	(make element gi: "DT"
	      (process-node-list title))
	(make element gi: "DD"
	      (process-qanda-toc)))))
  
  (element (qandadiv title)
    (let* ((hnr     (hierarchical-number-recursive (normalize "qandadiv")
						   (current-node)))
	   (number  (let loop ((numlist hnr) (number "") (sep ""))
		      (if (null? numlist)
			  number
			  (loop (cdr numlist) 
				(string-append number
					       sep
					       (number->string (car numlist)))
				".")))))
      (make sequence
	(literal number ". ")
	(make element gi: "A"
	      attributes: (list (list "HREF" 
				      (href-to (parent (current-node)))))
	      (process-children)))))

  (element qandaentry
    (process-children))

  (element question
    (let* ((inhlabel (inherited-attribute-string (normalize "defaultlabel")))
	   (deflabel (if inhlabel inhlabel (qanda-defaultlabel)))
	   (hnr      (hierarchical-number-recursive (normalize "qandadiv")
						    (current-node)))
	   (hnumber  (let loop ((numlist hnr) (number "") (sep ""))
		       (if (null? numlist)
			   number
			   (loop (cdr numlist) 
				 (string-append number
						sep
						(number->string (car numlist)))
				 "."))))
	   (cnumber  (child-number (parent (current-node))))
	   (number   (string-append hnumber 
				    "."
				    (number->string cnumber)))
	   (chlist   (children (current-node)))
	   (firstch  (node-list-first chlist)))
      (make element gi: "DT"
	    (if (equal? deflabel (normalize "number"))
		(literal number ". ")
		(empty-sosofo))
	    (make element gi: "A"
		  attributes: (list (list "HREF" (href-to (current-node))))
		  (process-node-list (children firstch))))))
  
  (element answer
    (empty-sosofo))
)

</style-specification-body>
</style-specification>

<external-specification id="docbook" document="docbook.dsl">

</style-sheet>
