#!/bin/sh
# cygconfig.sh,v 1.1 1999/07/18 22:28:39 joe Exp
#
# Usage: sh cygconfig.sh
#
#	Use this on Windows instead of the 'configure' script.
#
#	Generates Makefile from Makefile.in, with @CONFIGVARS@
#	hardcoded for CYGWIN (B20) development environment and Tcl 8.1
#
#	This only sort-of works... you'll most likely need to hack
#	the generated Makefile to get everything built.
#

prefix="/PROGRA~1"
TCL_PREFIX=$prefix/Tcl
STUB_LIB_SPEC="-ltclstub81"
TCL_SHLIB_LD_LIBS="-lmsvcrt"
TCL_LD_SEARCH_FLAGS="-L$TCL_PREFIX/lib"

includedir=$TCL_PREFIX/include
libdir=$TCL_PREFIX/lib

for file in Makefile.in expat/Makefile.in ; do
outfile=`echo $file | sed 's/.in$//' `
echo "Converting $file to $outfile"
sed "
/^SHELL.*=.*\/bin\/sh/s/^/#-/
#X /@+UNIX_ONLY:/,/@-UNIX_ONLY\./s/^/#-/
/@+UNIX_ONLY:/,/@-UNIX_ONLY\./d
/@+WINDOWS_ONLY:/,/@-WINDOWS_ONLY\./s/^#-//
s%@configure_input@%Automatically generated by $0%
s%@prefix@%$prefix%
s%@bindir@%\$(prefix)/bin%
s%@exec_prefix@%$prefix%
s%@includedir@%$includedir%
s%@libdir@%$libdir%

s%@CC@%gcc%
s%@CFLAGS@%-g -O2%
s%@DEFS@%-DUSE_TCL_STUBS -mdll -mno-cygwin%
# Note: DO NOT USE -ANSI
s%@EXTRA_DEBUG_FLAGS@%-Wall -pedantic%
s%@EXTRA_TARGETS@%%
s%@INSTALL@%install.exe%
s%@INSTALL_DATA@%\$(INSTALL)%
s%@INSTALL_PROGRAM@%\$(INSTALL)%
s%@LD_FLAGS@%%
s%@LIBS@%%
s%@RANLIB@%ranlib%

s%@EXE_SUFFIX@%.exe%

s%@TCL_SHLIB_SUFFIX@%.dll%
s%@TCL_SHLIB_CFLAGS@%%

s%@TCL_PREFIX@%$TCL_PREFIX%
s%@TCL_EXEC_PREFIX@%$TCL_PREFIX%
s%@TCL_SRC_DIR@%$TCL_PREFIX%

s%@STUB_LIB_SPEC@%$STUB_LIB_SPEC%
s%@TCL_SHLIB_LD_LIBS@%$TCL_SHLIB_LD_LIBS%
s%@TCL_LD_SEARCH_FLAGS@%$TCL_LD_SEARCH_FLAGS%

s%@SHLIB_TCL_LIB_SPEC@%XXX%
s%@TCL_LIBS@%XXX%
s%@TCL_LIB_SPEC@%XXX%
s%@TCL_SHLIB_LD@%XXX%
s%@TK_LD_SEARCH_FLAGS@%XXX%
s%@TK_LIBS@%XXX%
s%@TK_LIB_SPEC@%XXX%

" < $file > $outfile
done


#*EOF*
