
#ifndef __file_exception__
#define __file_exception__

#include <string>
#include "exception.hh"

namespace autil {
  struct FileException : virtual public Exception {
    string file;
    FileException(const string & f, const string & w) 
      : file(f)
    {message = w;}
  protected:
    FileException(const string & f) 
      : file(f)
    {}
  };

  struct CantReadFile : public FileException {
    CantReadFile(const string & f);
  };

  struct CantWriteFile : public FileException {
    CantWriteFile(const string & f);
  };

  struct BadFileFormat : public FileException {
    BadFileFormat(const string & f, const string & m = "");
  };

  struct RethrowWFile {
    virtual void rethrow_w_file(const string & f) const = 0;
  };
}

#endif
