#ifndef _autil_copy_ptr__
#define _autil_copy_ptr__


#include "copy_ptr.hh"

namespace autil {

  template <typename Class> 
  CopyPtr<Class>::CopyPtr(const CopyPtr<Class> &other) {
    if (other.own) 
      ptr = new Class(*other.ptr);
    else
      ptr = other.ptr;
    own = other.own;
  }

  template <typename Class>
  CopyPtr<Class> & 
  CopyPtr<Class>::operator= (const CopyPtr<Class> & other) 
  {
    if (own) delete ptr;
    if (other.own) 
      ptr = new Class(*other.ptr);
    else
      ptr = other.ptr;
    own = other.own;
    return *this;
  }

  template <typename Class>
  CopyPtr<Class>::~CopyPtr() {
    if (own) delete ptr;
  }

}

#endif
