#include "email.hh"
#include "skip-t.hh"
#include "clone_ptr-t.hh"
#include "ctype.h"

namespace afilter {

  template <typename T>
  EmailSkip<T>::EmailSkip(const ConfigData & opts) 
    : prev_newline(true), in_quote(false), n(0)
  {
    opts.retrieve_list("email-quote", *is_quote_char);
    margin = opts.retrieve_int("email-margin");
  }

  template <typename T>
  bool EmailSkip<T>::skip(char c, const Itr *) {
    if (prev_newline && is_quote_char->have(c))
      in_quote = true;
    if (c == '\n') {
      in_quote = false;
      prev_newline = true;
      n = 0;
    } else if (n < margin) {
      ++n;
    } else {
      prev_newline = false;
    }
    return in_quote;
  }
}
