# Additions to the SWIG-generated TeX__Kpathsea.pm
# $Id: Kpathsea_add.pl,v 1.4 1999/07/13 08:47:58 jdg Exp $
# CVS version tag name: $Name: debian_version_3_3_1_4 $
#
# Copyright 1999, Julian Gilbey <jdg@debian.org>
# 
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
# the GNU Public License, version 2 or later.  No warranty is implied.

package TeX::Kpathsea;  # to be on the safe side

use Carp;

# If we have a CVS version name, prefer that as it's more likely to be
# up-to-date.  There's a fallback default.  Use this ghastly mess so
# that MakeMaker can extract a version number automatically.

$VERSION = do { my @r=(q$Name: debian_version_3_3_1_4 $=~/\d+/g); @r ? sprintf "%d."."%02d"x$#r,@r : 3.030101 };

# We will deal with simple variables below; harder stuff first, though!

# We start by providing a safe wrapper around kpse_find_glyph, as the
# Kpathsea library dies if it is passed a null pointer as the fourth
# argument.

sub kpse_find_glyph {
  my @args = @_;
  if (defined($args[3]) and ref($args[3]) and
      $args[3]->isa('kpse_glyph_file_type')) {
    my $result = kpse_find_glyph_(@args);
    return $result;
  }
  else {
    carp "warning: kpse_find_glyph: third argument not a kpse_glyph_file_type object";
    my $glyph_ret = new kpse_glyph_file_type;
    my $result = kpse_find_glyph_(@args[0..2], $glyph_ret);
    return $result;
  }
}

# These arrays will hold the names to be exported, with whatever initial
# funny characters they may need
my (@exp_all_formats, @exp_all_short_formats);
my (@exp_all_functions, @exp_all_short_functions);

@kpse_all_format_names = (
    "kpse_gf_format",
    "kpse_pk_format",
    "kpse_any_glyph_format",
    "kpse_tfm_format",
    "kpse_afm_format",
    "kpse_base_format",
    "kpse_bib_format",
    "kpse_bst_format",
    "kpse_cnf_format",
    "kpse_db_format",
    "kpse_fmt_format",
    "kpse_fontmap_format",
    "kpse_mem_format",
    "kpse_mf_format",
    "kpse_mfpool_format",
    "kpse_mft_format",
    "kpse_mp_format",
    "kpse_mppool_format",
    "kpse_mpsupport_format",
    "kpse_ocp_format",
    "kpse_ofm_format",
    "kpse_opl_format",
    "kpse_otp_format",
    "kpse_ovf_format",
    "kpse_ovp_format",
    "kpse_pict_format",
    "kpse_tex_format",
    "kpse_texdoc_format",
    "kpse_texpool_format",
    "kpse_texsource_format",
    "kpse_tex_ps_header_format",
    "kpse_troff_font_format",
    "kpse_type1_format",
    "kpse_vf_format",
    "kpse_dvips_config_format",
    "kpse_ist_format",
    "kpse_truetype_format",
    "kpse_type42_format",
    "kpse_web2c_format",
    "kpse_program_text_format",
    "kpse_program_binary_format",
);

@exp_all_functions = (
    "kpse_maketex_option",
    "kpse_init_format",
    "kpse_find_file",
    "kpse_reset_program_name",
    "kpse_set_program_name",
    "kpse_init_prog",
    "kpse_find_glyph",
    "kpse_path_search",
    "kpse_all_path_search",
    "kpse_var_expand",
    "kpse_tilde_expand",
    "kpse_expand",
    "kpse_brace_expand",
    "kpse_path_expand",
);


# Next we create the arrays of things we'll export, taking a few
# shortcuts en route, such as performing the calculations of the
# format values once here to make an array of them (@kpse_all_formats).
# We also need to create the @kpse_format_info array, so we'll do that
# here as well.  This is done using the private kpse_format_info_getptr_
# function

{
    no strict 'refs';
    my ($fmt, $fmt_val, $short_fmt, $func, $short_func);

    foreach $fmt (@kpse_all_format_names) {
        # We may as well eval this, as then the function will
        # only have to do any work this once
        eval "sub $fmt { return ${$fmt}; }";
        $fmt_val = &$fmt;
        ($short_fmt = $fmt) =~ s/^kpse_//;
        *{$short_fmt} = *{$fmt};
        push @exp_all_formats, "*$fmt";
        push @exp_all_short_formats, "*$short_fmt";
        push @kpse_all_formats, $fmt_val;
        $kpse_format_info[$fmt_val] = kpse_format_info_getptr_($fmt_val);
    }

    foreach $func (@exp_all_functions) {
        ($short_func = $func) =~ s/^kpse_//;
        *{$short_func} = *{$func};
        push @exp_all_short_functions, $short_func;
    }
}

$false=0;
$true=1;
sub false { return 0; }
sub true { return 1; }

# Alias the kpse_format_info array and more....
*format_info=\@kpse_format_info;

*all_formats = \@kpse_all_formats;
*all_format_names = \@kpse_all_format_names;

*kpse_debug=\$kpathsea_debug;  # For consistency
*debug=\$kpathsea_debug;

# Program name...
*program_name=\$kpse_program_name;

# Version string...
*kpse_version=\$kpathsea_version_string;

# Finally, we create appropriate things for Exporter to work with
@EXPORT = qw( );

@EXPORT_OK = qw(*false *true);

%EXPORT_TAGS = (
    formats => ['@kpse_all_formats', @exp_all_formats],
    short_formats => ['@all_formats',
                         @exp_all_short_formats],
    functions => \@exp_all_functions,
    short_functions => \@exp_all_short_functions,
    misc => [qw(@kpse_format_info $kpathsea_debug $kpse_debug
                 $kpse_program_name @kpse_all_format_names
                 $kpse_version
               )],
    short_misc => [qw(@format_info $kpathsea_debug $debug
                       $program_name @all_format_names
                       $kpse_version
                     )],
);

# And put them all in @EXPORT_OK:
Exporter::export_ok_tags();

1;
