// SWIG interface file for the kpathsea library, version 3.2.
// $Id: Kpathsea.i,v 1.3 1999/06/23 11:21:10 jdg Exp $
// CVS version tag name: $Name: debian_version_3_3_1_4 $
//
// Copyright 1999, Julian Gilbey <jdg@debian.org>
// 
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
// the GNU Public License, version 2 or later.  No warranty is implied.

%title "Kpathsea scripting language interface", pre, skip=1, before
%style chop_left=3, chop_right=0, chop_top=0, chop_bottom=0

%module Kpathsea
// We avoid assert redefinition problems by moving Perl's version
// out of the way.
%{
#undef assert
#include <kpathsea/kpathsea.h>
%}

// Before we start looking at the header code, we will introduce a
// typemap for converting from a const_string * to a REFERENCE to a
// Perl array of strings.  This is needed by the kpse_format_info_type
// accessor functions, if we want them to do anything.  This code is
// based on the example code in the SWIG manual.

%typemap(perl5,out) const_string *, string * {
    AV *myav;
    SV **svs;
    int i = 0, len = 0;
    /* Figure out how many elements we have */
    while ($source && $source[len])
        len++;
    if (len>0) {
        svs = (SV **) malloc(len*sizeof(SV *));
        for (i = 0; i < len ; i++) {
            svs[i] = sv_newmortal();
            sv_setpv((SV*)svs[i],$source[i]);
        };
        myav = av_make(len,svs);
        free(svs);
    }
    else myav = newAV();
    $target = newRV((SV*)myav);
    sv_2mortal($target);
    argvi++;  /* One output value on the stack: IMPORTANT!! */
}

// We also play around with the definition of boolean so that Perl's
// notion of true matches C's.

// First, we fake the definition of boolean to avoid the enum
typedef char boolean;

// And now a typemap for booleans:

%typemap(perl5,in) boolean {
  $target = (boolean) SvTRUE((SV*) $source);
}


// From types.h

/* The usual null-terminated string.  */
typedef char *string;

// This was a const char *, but SWIG 1.1pl5 is buggy and can't deal with
// consts.  So I've removed the 'const' declaration and used some %readonly,
// %readwrite pairs where appropriate.

/* A pointer to constant data.  (ANSI says `const string' is
   `char * const', which is a constant pointer to non-constant data.)  */
typedef char *const_string;


// First of all, we make sure that we have the version number available
// This is defined in version.c
%readonly
extern string kpathsea_version_string;
%readwrite


// From debug.h

/* Bit vector defining what we should trace.  */
extern unsigned kpathsea_debug;


// From progname.h

%readonly
extern string kpse_program_name;
%readwrite

// We don't provide kpse_set_program_name to the Perl code, but rather
// call it directly from the C initialisation routine.  We do, however,
// use Perl's $0 to find out the program name.  (We assume that this
// hasn't been tampered with, although it's not such a disaster if
// it has.)

%init %{
  kpse_set_program_name(SvPV(perl_get_sv("0",0),na), NULL);
%}

// From proginit.h

// The kpse_init_prog might expect NULL pointers to be given as either
// or both of the last two parameters, so we'd better have a way of
// expressing this.  Don't you just *love* typemaps!
//
// The following typemap achieves this by interpreting 0 as NULL in this
// case.

%typemap(perl5,in) const_string mode, fallback {
  if (SvIOK($source) && SvIV($source) == 0)
    $target = NULL;
  else
    $target = SvPV($source,na);
}

/* Common initializations for DVI drivers -- check for `PREFIX'SIZES and
   `PREFIX'FONTS environment variables, setenv MAKETEX_MODE to MODE,
   etc., etc.  See the source.  */
extern void
kpse_init_prog (const_string prefix, unsigned dpi, const_string mode,
                   const_string fallback);

// Clear the typemap....
%typemap(perl5,in) const_string mode, fallback;


// From tex-file.h

typedef enum
{
  kpse_gf_format,
  kpse_pk_format,
  kpse_any_glyph_format,	/* ``any'' meaning anything above */
  kpse_tfm_format, 
  kpse_afm_format, 
  kpse_base_format, 
  kpse_bib_format, 
  kpse_bst_format, 
  kpse_cnf_format,
  kpse_db_format,
  kpse_fmt_format,
  kpse_fontmap_format,
  kpse_mem_format,
  kpse_mf_format, 
  kpse_mfpool_format, 
  kpse_mft_format, 
  kpse_mp_format, 
  kpse_mppool_format, 
  kpse_mpsupport_format,
  kpse_ocp_format,
  kpse_ofm_format, 
  kpse_opl_format,
  kpse_otp_format,
  kpse_ovf_format,
  kpse_ovp_format,
  kpse_pict_format,
  kpse_tex_format,
  kpse_texdoc_format,
  kpse_texpool_format,
  kpse_texsource_format,
  kpse_tex_ps_header_format,
  kpse_troff_font_format,
  kpse_type1_format, 
  kpse_vf_format,
  kpse_dvips_config_format,
  kpse_ist_format,
  kpse_truetype_format,
  kpse_type42_format,
  kpse_web2c_format,
  kpse_program_text_format,
  kpse_program_binary_format,
  kpse_last_format /* one past last index */
} kpse_file_format_type;

// We include this as it's used by kpse_format_info_type

/* Perhaps we could use this for path values themselves; for now, we use
   it only for the program_enabled_p value.  */
typedef enum
{
  kpse_src_implicit,   /* C initialization to zero */
  kpse_src_compile,    /* configure/compile-time default */
  kpse_src_texmf_cnf,  /* texmf.cnf, the kpathsea config file */
  kpse_src_client_cnf, /* application config file, e.g., config.ps */
  kpse_src_env,        /* environment variable */
  kpse_src_x,          /* X Window System resource */
  kpse_src_cmdline     /* command-line option */
} kpse_src_type;

%readonly
/* For each file format, we record the following information.  The main
   thing that is not part of this structure is the environment variable
   lists. They are used directly in tex-file.c. We could incorporate
   them here, but it would complicate the code a bit. We could also do
   it via variable expansion, but not now, maybe not ever:
   ${PKFONTS-${TEXFONTS-/usr/local/lib/texmf/fonts//}}.  */
typedef struct
{
  const_string type;		/* Human-readable description.  */
  const_string path;		/* The search path to use.  */
  const_string raw_path;	/* Pre-$~ (but post-default) expansion.  */
  const_string path_source;	/* Where the path started from.  */
  const_string override_path;	/* From client environment variable.  */
  const_string client_path;	/* E.g., from dvips's config.ps.  */
  const_string cnf_path;	/* From texmf.cnf.  */
  const_string default_path;	/* If all else fails.  */
  const_string *suffix;		/* For kpse_find_file to check for/append.  */
  const_string *alt_suffix;	/* More suffixes to check for.  */
  boolean suffix_search_only;	/* Only search with a suffix?  */
  const_string program;		/* ``mktexpk'', etc.  */
  const_string program_args;	/* Args to `program'.  */
  boolean program_enabled_p;	/* Invoke `program'?  */
  kpse_src_type program_enable_level; /* Who said to invoke `program'.  */
  boolean binmode;              /* The files must be opened in binary mode. */
} kpse_format_info_type;
%readwrite

// Now we're gonna have problems: SWIG can't handle arrays easily.
// So let's create a helper function and rename this array.

%inline %{
    kpse_format_info_type
        *kpse_format_info_getptr_(kpse_file_format_type f)
    {
        return (kpse_format_info_type *)(&kpse_format_info[f]);
    }
%}

/* Call kpse_set_program_enabled with VALUE and the format corresponding
   to FMTNAME.  */
extern void kpse_maketex_option (const_string fmtname, boolean value);

/* Initialize the info for the given format.  This is called
   automatically by `kpse_find_file', but the glyph searching (for
   example) can't use that function, so make it available.  */
extern const_string kpse_init_format (kpse_file_format_type f);

// As all of the returned strings we will be using will be NULL
// if the file was not found, so instead of returning an undef value,
// let's return an empty string instead, as then we will not end up with
// unnecessary warnings from perl -w.

%typemap(perl5,out) string {
    if ($source == NULL) $target = newSVpv("",0);
    else $target = newSVpv($source,0);
    argvi++;  /* One output value on the stack: IMPORTANT!! */
}

/* If FORMAT has a non-null `suffix' member, append it to NAME "."
   and call `kpse_path_search' with the result and the other arguments.
   If that fails, try just NAME.  */
extern string kpse_find_file (const_string name,  
                            kpse_file_format_type format, boolean must_exist);

/* This function is used to set kpse_program_name (from progname.c) to
   a different value.  It will clear the path searching information, to
   ensure that the search paths are appropriate to the new name. */
extern void kpse_reset_program_name (const_string progname);


// From tex-glyph.h

typedef struct
{
  string name;			/* font name found */
  unsigned dpi;			/* size found, for glyphs */
  kpse_file_format_type format;	/* glyph format found */
  kpse_glyph_source_type source;	/* where we found it */
  kpse_glyph_file_type();     /* SWIG constructor method */
  ~kpse_glyph_file_type();    /* SWIG destructor method */
} kpse_glyph_file_type;

/* Search first for the font named FONT_NAME at resolution DPI in the
   glyph format FORMAT (see `try_size' for details of format searching).
   Then try resolutions within KPSE_BITMAP_TOLERANCE of DPI.  Then try
   the resolutions in `kpse_fallback_sizes', then within the tolerance
   of each of those.  Then if FONT_NAME is an alias defined in a
   texfonts.map do all the above for its real name.  Then try the above
   for kpse_fallback_name.  Then fail.  Return either the filename
   found, or NULL.  Also return information about the file found in
   *GLYPH_FILE.  */

/* We rename this to a private name so that we can test for a sensible
   fourth parameter first.  Core dumps are not nice.  */
%name(kpse_find_glyph_) extern string kpse_find_glyph (
                                  const_string font_name, unsigned dpi, 
                                  kpse_file_format_type format,
                                  kpse_glyph_file_type *glyph_file);


// From pathsearch.h

/* Call `kpse_expand' on NAME.  If the result is an absolute or
   explicitly relative filename, check whether it is a readable
   (regular) file.
   
   Otherwise, look in each of the directories specified in PATH (also do
   tilde and variable expansion on elements in PATH), using a prebuilt
   db (see db.h) if it's relevant for a given path element.
   
   If the prebuilt db doesn't exist, or if MUST_EXIST is true and NAME
   isn't found in the prebuilt db, look on the filesystem.  (I.e., if
   MUST_EXIST is false, and NAME isn't found in the db, do *not* look on
   the filesystem.)
   
   The caller must expand PATH. This is because it makes more sense to
   do this once, in advance, instead of for every search using it.
   
   In any case, return the complete filename if found, otherwise NULL.  */
extern string kpse_path_search (const_string path, const_string name,
                                   boolean must_exist);

/* Like `kpse_path_search' with MUST_EXIST true, but return a list of
   all the filenames (or NULL if none), instead of taking the first.  */
extern string *kpse_all_path_search (const_string path, const_string name);


// From variable.h

/* Expand $VAR and ${VAR} references in SRC, returning the (always newly
   dynamically-allocated) result.  An unterminated ${ or any other
   character following $ produce error messages, and that part of SRC is
   ignored.  In the $VAR form, the variable name consists of consecutive
   letters, digits, and underscores.  In the ${VAR} form, the variable
   name consists of whatever is between the braces.
   
   In any case, ``expansion'' means calling `getenv'; if the variable is not
   set, look in texmf.cnf files for a definition.  If not set there, either,
   the expansion is the empty string (no error).  */
extern string kpse_var_expand (const_string src);


// From tilde.h

/* Replace a leading ~ or ~name in FILENAME with getenv ("HOME") or
   name's home directory, respectively.  FILENAME may not be null.  */
extern string kpse_tilde_expand (const_string filename);


// From expand.h

/* Call kpse_var_expand and kpse_tilde_expand (in that order).  Result
   is always in fresh memory, even if no expansions were done.  */
extern string kpse_expand (const_string s);

/* Do brace expansion and call `kpse_expand' on each element of the
   result; return the final expansion (always in fresh memory, even if
   no expansions were done).  We don't call `kpse_expand_default'
   because there is a whole sequence of defaults to run through; see
   `kpse_init_format'.  */
extern string kpse_brace_expand (const_string path);

/* Do brace expansion and call `kpse_expand' on each argument of the
   result, then expand any `//' constructs.  The final expansion (always
   in fresh memory) is a path of all the existing directories that match
   the pattern. */
extern string kpse_path_expand (const_string path);

// Local variables:
// mode: c
// End:
