/* this module have functions for a jxl4 font format */

#include	"defs.h"
#include	"global.h"
#include	"rastfont.h"
#include	"jxl4font.h"

int jxl4type_access();
void init_jxl_fontinfo();
struct fontop jxlop = {
    "jxl",
    pathtype_init,
    jxl4type_access,
    init_jxl_fontinfo,
};

#define	NJXL4CHARS	(84*94)

static FILE *fntfp;
void loadjxlchar();

jxl4type_access(proto, fe, acca)
char *proto;
struct font_entry *fe;
struct accarg *acca;
{
    BOOLEAN ok;

    rast_mag(proto, fe, acca, 5);
    pave(fe->name, proto, acca);
    ok = access(fe->name, R_OK) == 0;
#ifdef DEBUG
    rast_debug_report(fe, acca, ok);
#endif
    return (ok ? check_id(fe->name, JXL4ID) : FALSE);
}

void
init_jxl_fontinfo(fe)
register struct font_entry *fe;
{
    register int i;
    struct rastinitfontinfo *rii;
    int	jxl_markchar();
    void read_jxl_fontinfo();

    fe->fnt_markchar = jxl_markchar;
    fe->fnt_readfontinfo = read_jxl_fontinfo;
    rii = (struct rastinitfontinfo *)
	alloc_check(malloc((unsigned)sizeof(struct rastinitfontinfo)+
			   (NJXL4CHARS-1)*sizeof(char)),
		    "jxl rastinitfontinfo");
    for (i = 0; i < NJXL4CHARS; i++)
	rii->mark[i] = FALSE;
    rii->maxc = 0;
    rii->corrfact = rastaccinfo(fe)->corrfact;
    rastinifinfo(fe) = rii;
}

jxl_markchar(c)
int c;
{
    c = jis_to_idx94(c);
    rastinifinfo(curfontent)->mark[c] = TRUE;
    if (c > rastinifinfo(curfontent)->maxc)
	rastinifinfo(curfontent)->maxc = c;
}

void
read_jxl_fontinfo(fe)
register struct font_entry *fe;
{
    int t;
    register struct JXL4 *jxl4p;
    struct JXL4_INFO jxl4_info;
    struct rastinitfontinfo *rii;
    struct rastfntinfo *rfi;
    int ds, mg;

    openfontfile(fe);
    fntfp = fe->openfile;
    if ((t = getuint(fntfp, 4)) != JXL4ID)
	Fatal("JXL ID = %d, can only process JXL4 ID = %d files",
	      t, JXL4ID);
    (void)fseek(fntfp, -4L, 2);
    if ((t = getuint(fntfp, 4)) != JXL4ID)
	Fatal("Tail JXL ID = %d, can only process JXL4 ID = %d files",
	      t, JXL4ID);

    if ((jxl4p = (struct JXL4 *)malloc(sizeof(struct JXL4))) == NULL)
	Fatal("can't allocate jxl4 for font"); 
    (void)fseek(fntfp, -64L, 2);
    jxl4p->check_sum = getuint(fntfp, 4);
    jxl4p->magnification = mg = getuint(fntfp, 4);
    jxl4p->design_size = ds = getuint(fntfp, 4);
    jxl4p->fixed_pxl_size = getuint(fntfp, 4);
    jxl4p->fixed_tfm_size = getuint(fntfp, 4);
    jxl4p->tfm_ptr        = getuint(fntfp, 4);
    jxl4p->tfm_size       = getuint(fntfp, 4);
    jxl4p->x_info_ptr     = getuint(fntfp, 4);
    jxl4p->x_info_size    = getuint(fntfp, 4);
    jxl4p->y_info_ptr     = getuint(fntfp, 4);
    jxl4p->y_info_size    = getuint(fntfp, 4);
    jxl4p->dir_size       = getuint(fntfp, 4);
    jxl4p->dir_ptr_0      = getuint(fntfp, 4);
    jxl4p->dir_ptr_1      = getuint(fntfp, 4);
    jxl4p->dir_ptr_2      = getuint(fntfp, 4);

    rii = rastinifinfo(fe);
    rastfinfo(fe) = rfi = alloc_rastfinfo(rii->maxc+1, TRUE, rii);
    dev_jxl4_initfe(fe);
    /* rfi->designsize = ds; /* not used */
    /* rfi->font_mag = mg;   /* not used */
    rfi->nfntchars = rii->maxc + 1;
    jxl4_info.jxl4 = jxl4p;
    jxl4info(fe, &jxl4_info);
    jxl4charinfo(fe, &jxl4_info, rii);

    free((char *)jxl4_info.yinfo);
    free((char *)jxl4_info.xinfo);
    free((char *)jxl4_info.tfmtable);
    free((char *)jxl4_info.jxl4);
    free((char *)rii);
}

/* ARGSUSED */
jxl4info(fentry, jxl4_info)
struct font_entry *fentry;
struct JXL4_INFO *jxl4_info;
{
    unsigned int size;
    int rsize, i;
    register struct JXL4 *jxl4p;

    jxl4p = jxl4_info->jxl4;

    /*
     * Get all tfm-width table entry.
     */

    size = sizeof(struct TFM_TABLE ) * jxl4p->tfm_size;
    rsize = jxl4p->tfm_size;

    if ((jxl4_info->tfmtable = (struct TFM_TABLE *)malloc(size)) == NULL)
	Fatal("tfm_width");	/* exit */

    (void)fseek(fntfp, (long)jxl4p->tfm_ptr, 0);
    for (i=0; i<rsize; i++)
	jxl4_info->tfmtable[i].entry = getuint(fntfp, 4);

    /*
     * Get X_info & Y_info.
     */

    size = sizeof(struct X_INFO) * jxl4p->x_info_size;
    rsize = jxl4p->x_info_size;

    if ((jxl4_info->xinfo = (struct X_INFO *)malloc(size)) == NULL)
	Fatal("x_info");	/* exit */

    (void)fseek(fntfp, (long)jxl4p->x_info_ptr, 0);
    for (i=0; i<rsize; i++) {
	jxl4_info->xinfo[i].x_offset = getint(fntfp, 2);
	jxl4_info->xinfo[i].x_pix    = getint(fntfp, 2);
	jxl4_info->xinfo[i].x_offset_p = getint(fntfp, 2);
    }

    size = sizeof(struct Y_INFO) * jxl4p->y_info_size;
    rsize = jxl4p->y_info_size;

    if ((jxl4_info->yinfo = (struct Y_INFO *)malloc(size)) == NULL)
	Fatal("y_info");	/* exit */

    (void)fseek(fntfp, (long)jxl4p->y_info_ptr, 0);
    for (i=0; i<rsize; i++) {
	jxl4_info->yinfo[i].y_offset = getint(fntfp, 2);
	jxl4_info->yinfo[i].y_pix    = getint(fntfp, 2);
	jxl4_info->yinfo[i].y_offset_p = getint(fntfp, 2);
    }
}

jxl4charinfo(fe, jxl4_info, rii)
struct font_entry *fe;
struct JXL4_INFO *jxl4_info;
struct rastinitfontinfo *rii;
{
    int dirptr0, dirptr1, dirptr2;

    dirptr0 = jxl4_info->jxl4->dir_ptr_0;
    dirptr1 = jxl4_info->jxl4->dir_ptr_1;
    dirptr2 = jxl4_info->jxl4->dir_ptr_2;

    /* treat jis space specially, because jxl does not have its glyf */
    jxl4jisspace(fe, jxl4_info, rii);
    /* non kanji */
    if ((dirptr0 != dirptr1) && (dirptr0 != dirptr2)) {
	jxl4chars(fe, jxl4_info, rii,
		  dirptr0, BeginOfNonKCode, EndOfNonKCode);
    }
    /* level-1 kanji */
    if (dirptr1 != 0 && rii->maxc >= BeginOfLevel1KCode) {
	jxl4chars(fe, jxl4_info, rii,
		  dirptr1, BeginOfLevel1KCode, BeginOfLevel2KCode-1);
    }
    /* level-2 kanji */
    if (dirptr2 != 0 && rii->maxc >= BeginOfLevel2KCode) {
	jxl4chars(fe, jxl4_info, rii,
		  dirptr2, BeginOfLevel2KCode, rii->maxc);
    }
}

#define	JISSpaceKCode		0

jxl4jisspace(fe, jxl4_info, rii)
struct font_entry *fe;
struct JXL4_INFO *jxl4_info;
struct rastinitfontinfo *rii;
{
    register struct rastchar_entry *ce;

    if (rii->mark[JISSpaceKCode]) {
	ce = &(rastfinfo(fe)->ch[JISSpaceKCode]);
	/* I don't know why ce->height = 1 does not work. (T. Sakurai) */
	ce->where.pixptr = "\0\0";
	ce->width = 1;
	ce->nbpl = 1;
	ce->xoffset = 0;
	ce->height = 2;
	ce->yoffset = ce->height;
	ce->tfmw = scale(jxl4_info->jxl4->fixed_tfm_size, fe->s);
	dev_rast_initfontdict(fe, JISSpaceKCode);
	rii->mark[JISSpaceKCode] = FALSE;
    }
}

jxl4chars(fe, jxl4_info, rii, dirptr, bc, ec)
struct font_entry *fe;
struct JXL4_INFO *jxl4_info;
struct rastinitfontinfo *rii;
int dirptr, bc, ec;
{
    register struct rastchar_entry *ce;
    int index, i;
    int tfm_index, x_info_index, y_info_index;

    for (i = bc, index = 0; i <= ec; i++, index++) {
	if (rii->mark[i] == FALSE)
	    continue;

	ce = &(rastfinfo(fe)->ch[i]);
	(void)fseek(fntfp, (long)(dirptr + (SIZEof_PXL_DIR*index)), 0);

	tfm_index = getuint(fntfp, 1);
	ce->where.fileoffset = getuint(fntfp, 3);
	x_info_index = getuint(fntfp, 2);
	y_info_index = getuint(fntfp, 2);

	ce->width = jxl4_info->xinfo[x_info_index].x_pix;
	ce->nbpl = (unsigned short)(ce->width + 7) >> 3;
	ce->xoffset = jxl4_info->xinfo[x_info_index].x_offset;

	ce->height = jxl4_info->yinfo[y_info_index].y_pix;
	ce->yoffset = jxl4_info->yinfo[y_info_index].y_offset;

	ce->tfmw = scale(jxl4_info->tfmtable[tfm_index].entry, fe->s);

	if (ce->where.fileoffset == 0) {
	    /*ce->where.fileoffset = NONEXISTANT;*/
	    Warning("The glyf of char %x in %s missing\n",
		    idx94_to_jis(i), fe->name);
	    continue;
	}
	loadjxlchar(fe, ce);
	dev_rast_initfontdict(fe, i);
    }
}

/* ARGSUSED */
void
loadjxlchar(fe, ce)
struct font_entry *fe;
register struct rastchar_entry *ce;
{
    char *pixel;

    (void)fseek(fntfp, (long) ce->where.fileoffset, 0);
    if ((pixel = (char *)malloc((unsigned int) ce->nbpl*ce->height)) == NULL)
	Fatal("Unable to allocate memory for char\n");
    jxlexp(fntfp, (unsigned char *)pixel,
	   (int)ce->nbpl, (int)ce->width, (int)ce->height);
    ce->where.pixptr = pixel;
}

DEV_FONT
jxl4_fontdict(fe, c)
struct font_entry *fe;
int c;
{
    return (rast_fontdict(fe, jis_to_idx94(c)));
}
