#ifndef AudioDriver_h
#define AudioDriver_h

#include <errno.h>
#include <fcntl.h>
#include <stdio.h>
#include <string.h>
#include <sys/ioctl.h>
#include <unistd.h>

// These next include were not required if libsidplay would not
// provide related HAVE_* definitions.
#include <sidplay/compconf.h>
#if defined(HAVE_SOLARIS) && defined(HAVE_SUN_AUDIOIO_H)
  #include <sun/audioio.h>
//  #include <sun/dbriio.h>
#elif defined(HAVE_SOLARIS) && defined(HAVE_SYS_AUDIOIO_H)
  #include <sys/audioio.h>
#elif defined(HAVE_SUNOS) && defined(HAVE_SUN_AUDIOIO_H)
  #include <sun/audioio.h>
//  #include <sun/dbriio.h>
#elif defined(HAVE_SUNOS) && defined(HAVE_SYS_AUDIOIO_H)
  #include <sys/audioio.h>
#else
  #error Audio driver not supported.
#endif

#include "AudioConfig.h"

class AudioDriver
{
	
 public:  // --------------------------------------------------------- public

    static const char AUDIODEVICE[];
	
    AudioDriver();
    ~AudioDriver();

    // Check device availability and write permissions.
    bool isThere();

    bool open(const AudioConfig&);
	
    // Free and close opened audio device and reset any variables that
    // reflect the current state of the driver.
    void close();
	
    void play(void* buffer, unsigned long int bufferSize);

    bool reset()
    {
        return true;  // not available
    }
	
    int getAudioHandle()
    {
        return audioHd;
    }
	
	const AudioConfig& getConfig() const
    {
        return config;
    }
    
    const char* getErrorString() const
    {
        return errorString;
    }
			
 private:  // ------------------------------------------------------- private

    void outOfOrder();
    
    char* errorString;
    int audioHd;
    AudioConfig config;

};

#endif  // AudioDriver_h
