#ifndef WaveViewDialog_h
#define WaveViewDialog_h

#include <math.h>

#include <qpainter.h>
#include <qpixmap.h>

#include "WaveViewDialogData.h"
#include "AudioConfig.h"
#include "GlobalIcon.h"

class WaveViewDialog : public WaveViewDialogData
{
    Q_OBJECT

 public:

    WaveViewDialog(QWidget* parent = NULL, const char* name = NULL);
    ~WaveViewDialog();

    void show();
    bool isShown();
    void paintWaveformFunc(const void*);
    void setConfig(const AudioConfig&);

 protected slots:
    
    void done(int);

 protected:
    
    void paintEvent(QPaintEvent*);
    void resizeEvent(QResizeEvent*);
    
    bool shown;
    const QPixmap* myWavePicOrig;
    const void* lastBuffer;
    AudioConfig config;

};

#endif  // WaveViewDialog_h
