#ifndef VCT_H
#define VCT_H

#define S_make_vct       "make-vct"
#define S_vct_addB       "vct-add!"
#define S_vct_copy       "vct-copy"
#define S_vct_length     "vct-length"
#define S_vct_multiplyB  "vct-multiply!"
#define S_vct_offsetB    "vct-offset!"
#define S_vct_ref        "vct-ref"
#define S_vct_scaleB     "vct-scale!"
#define S_vct_fillB      "vct-fill!"
#define S_vct_setB       "vct-set!"
#define S_vct_p          "vct?"
#define S_list2vct       "list->vct"

#if HAVE_GUILE

#include <guile/gh.h>

#define ERRVCT1(a,b) SCM_ASSERT((vct_p(a)),a,SCM_ARG1,b)
#define ERRVCT2(a,b) SCM_ASSERT((vct_p(a)),a,SCM_ARG2,b)

typedef struct {
  int length;
  float *data;
} vct;

void init_vct(void);
int vct_p(SCM obj);
SCM make_vct(int len, float *data);
vct *get_vct(SCM arg);
void set_vct_print_length(int len);

#endif
#endif
