.\" $NCDId: @(#)AuGElSt.man,v 1.1 1994/09/27 00:28:44 greg Exp $
.\" copyright 1994 Steven King
.\"
.\" portions are
.\" * Copyright 1993 Network Computing Devices, Inc.
.\" *
.\" * Permission to use, copy, modify, distribute, and sell this software and its
.\" * documentation for any purpose is hereby granted without fee, provided that
.\" * the above copyright notice appear in all copies and that both that
.\" * copyright notice and this permission notice appear in supporting
.\" * documentation, and that the name Network Computing Devices, Inc. not be
.\" * used in advertising or publicity pertaining to distribution of this
.\" * software without specific, written prior permission.
.\" * 
.\" * THIS SOFTWARE IS PROVIDED 'AS-IS'.  NETWORK COMPUTING DEVICES, INC.,
.\" * DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING WITHOUT
.\" * LIMITATION ALL IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
.\" * PARTICULAR PURPOSE, OR NONINFRINGEMENT.  IN NO EVENT SHALL NETWORK
.\" * COMPUTING DEVICES, INC., BE LIABLE FOR ANY DAMAGES WHATSOEVER, INCLUDING
.\" * SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES, INCLUDING LOSS OF USE, DATA,
.\" * OR PROFITS, EVEN IF ADVISED OF THE POSSIBILITY THEREOF, AND REGARDLESS OF
.\" * WHETHER IN AN ACTION IN CONTRACT, TORT OR NEGLIGENCE, ARISING OUT OF OR IN
.\" * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
.\"
.\" $Id: AuGetElementStates.man,v 1.3 1994/08/11 17:59:14 sking Exp $
.TH AuGetElementStates 3 "1.2" "audiolib - flow elements states"
.SH \fBName\fP
\fBAuGetElementStates\fP \- get the state of elements in a flow
.SH \fBSynopsis\fP
#include <audio/audiolib.h>
.sp 1
\fBAuElementState\fP *\fBAuGetElementStates\fP(\fIserver\fP, \fInum_states\fP, \fIstates\fP, \fIstatus\fP)
.br
    \fBAuServer\fP *\fIserver\fP;
.br
    int *\fInum_states\fP; /* \fBSEND\fP and \fBRETURN\fP */
.br
    \fBAuElementState\fP *\fIstates\fP;
.br
    \fBAuStatus\fP *\fIstatus\fP; /* \fBRETURN\fP */
.SH \fBArguments\fP
.IP \fIserver\fP 1i
Specifies the connection to the audio server.
.IP \fInum_states\fP 1i
Specifies the number of element states in \fIstates\fP and returns the number of element states actually returned.
.IP \fIstates\fP 1i
Specifies the list  of \fBAuElementState\fP structures indicating the flow and element number of the elements to return the state of.
.IP \fIstatus\fP 1i
If non-NULL, flush the output buffer and return the status from the server.
.SH \fBDescription\fP
\fBAuGetElementStates\fP returns a list of element states, or NULL, with num_states set to 0, if there was an error.
Use \fBAuFreeElementStates\fP to free this list when nolonger needed.
.SH NOTES
Attempting to get the state of a non-component element (AddConstant, Bundle, ExportMonitor, MultiplyConstant, and Sum) will result in an error.
.SH \fBErrors\fP
\fBAuBadFlow\fP,
\fBAuBadLength\fP,
\fBAuBadAlloc\fP,
\fBAuBadElement\fP.
.SH \fBSee Also\fP
\fBAuSetElementStates\fP.
.sp 1
audiolib \- \fBNetwork Audio System\fP C Language Interface
