// rubbertext.h

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/


// Subclass of InterViews Rubberband class which allows text to be drawn on
// a canvas in such a way that it can be updated (properly erased and redrawn)
// while it is moving on the screen in response to mouse movement.  Used by
// the ChannelGraph class.

#ifndef RUBBERTEXT_H
#define RUBBERTEXT_H

#ifdef __GNUG__
#pragma interface
#endif

#include "localdefs.h"
#include <InterViews/rubband.h>

class Painter;

class RubberText : public Rubberband {
public:
	RubberText(Painter *p, Canvas *c, Coord x, Coord y, const char *text);
	virtual ~RubberText();
	redefined void Draw();
	redefined void Erase();
	redefined void SetPainter(Painter *);
	void Track(const char *t, Coord x, Coord y);
protected:
	void setText(const char *t);
private:
	char *string;
	char *oldstring;
	boolean erasing;
};

#endif

