// datafile.h

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/


// The DataFile class is specialized for reading and writing Data objects to 
// and from disk.  It contains additional information about read durations and
// inskip times for cases when only portions of files are to be read in.  It
// interacts closely with the Header subclasses.

#ifndef DATAFILE_H
#ifdef __GNUG__
#pragma interface
#endif
#define DATAFILE_H

#include "diskfile.h"

class DataFile : public DiskFile {
	typedef DiskFile Super;
public:
	DataFile();
	DataFile(const char*, const char* mode="r", double skip=0, double dur=0);
	virtual ~DataFile() {}
	redefined const char* name();
	inline boolean bytesAreSwapped();
	int dataSize() const;		// size of data minus header
	int readSize();			// size of read (offset subtracted)
	inline DiskFile& skip(long pos);
protected:
	void setBytesSwapped(boolean swapped) { needSwapping = swapped; }
	double skipTime() { return skiptime; }
	double duration() { return durtime; }
	void setHeaderSize(int hsize) { headersize = hsize; }
	void setReadSize(int rsize) { readBytes = rsize; }
	void setOffset(int offst) { offset = offst; }
private:
	boolean needSwapping;	// do read/written bytes need swapping?
	int headersize;			// size of data file header (set by Header class)
	int offset;				// any additional offset (in bytes)
	int readBytes;			// amount to read (in bytes, zero if reading all)
	double skiptime;		// stored skip and dur in seconds -- converted
	double durtime;			// into bytes by the Header class
	friend class Header;
};

inline boolean
DataFile::bytesAreSwapped() { return needSwapping; }

inline DiskFile&
DataFile::skip(long pos) { return seek(pos, 1); }

#endif /* DATAFILE_H */
