// conv_device.h

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/


// ConverterDevice is a subclass of Converter and Device used as the base class
// for all converter classes which communicate with the raw device via standard
// standard UNIX i/o.

#ifndef CONV_DEVICE_H
#ifdef __GNUG__
#pragma interface
#endif
#define CONV_DEVICE_H

#include "converter.h"
#include "device.h"

class ConverterDevice : public RealConverter, virtual public Device {
public:
	ConverterDevice(const char* devName);
	virtual ~ConverterDevice() { delete [] device_name; }
	redefined int stop();
protected:
	redefined int fdesc() const;
	redefined boolean open(const char* name, int mode);
	redefined boolean close();
	redefined boolean ioctl(unsigned long req, char *argp);
	redefined int doConversion(StatusAction* askedToStop);
	redefined int doRecording(StatusAction* askedToStop);
	redefined void fail();
	const char* deviceName() { return device_name; }
	virtual boolean reOpen();
	virtual int writeSize() = 0;
	virtual int readSize() = 0;
	virtual void waitForDevice() {}
private:
	void setDeviceName(const char*);
	char* device_name;			// stored name of raw device
};

inline int ConverterDevice::fdesc() const { return Device::fdesc(); }

inline boolean ConverterDevice::open(const char* name, int mode) {
	return Device::open(name, mode);
}

inline boolean ConverterDevice::close() { return Device::close(); }

inline boolean ConverterDevice::ioctl(unsigned long req, char *argp) {
	return Device::ioctl(req, argp);
}

#endif
