/* Gtick  -  A Gtk+ Metronome
 *
 *   mixer.c: Sound mixer code, for volume type stuff..
 *
 * Copyright (c) 1999, Alex Roberts
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
 
#include <unistd.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#ifdef FREEBSD
#include <machine/soundcard.h>
#else
#include <linux/soundcard.h>
#endif
#include <glib.h>

#include "gtick.h"

static gint mix;
static gchar devName[] = "/dev/mixer";

void gtInitMixer()
{
#ifdef DEBUG
	g_print ("gtInitMixer: Initialising %s..\n", devName);
#endif
	
	if ((mix = open (devName, O_RDWR, 0)) == -1)
	  {
	    g_error ("Couldnt open mixer device /dev/mixer\n");
	    exit (1);
	  }
	 
}

void gtCloseMixer()
{
#ifdef DEBUG
	g_print ("gtCloseMixer: Closing /dev/mixer..\n");
#endif
	close (mix);
}


gint gtGetMixer()
{
	gint vol, r, l;
	
	ioctl (mix, MIXER_READ(SOUND_MIXER_PCM), &vol);
	
	l = vol & 0xff;
	r = (vol & 0xff00) >> 8;

#ifdef DEBUG	
	g_print ("gtGetMixer: vol=%d, l=%d, r=%d\n", vol, l, r);
#endif
	
	return (r+l)/2;
}

void gtSetMixer (gint vol)
{
	gint tvol;
	
	tvol = (vol << 8) + vol;

#ifdef DEBUG	
	g_print ("gtSetMixer: Setting mixer value: %d\n", tvol);
#endif

	ioctl (mix, MIXER_WRITE(SOUND_MIXER_PCM), &tvol);
}
