/*   Groovy CD Rom Player Software

     Copyright (c) 1994      	Thomas McWilliams 
     Copyright (c) 1997,1998 	Mark Landis
   
     This program is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published by
     the Free Software Foundation; either version 2, or (at your option)
     any later version.
     
     This program is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.
     
     You should have received a copy of the GNU General Public License
     along with this program; if not, write to the Free Software
     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#include "struct.h"
#include "ncurses.h"

#define CDNULL 0
#define CDPLAY 1
#define CDPAUZ 3
#define CDSTOP 4
#define CDEJECT 5

#ifdef WBLAZY
#define WBS_DELAY 2
#define WBU_DELAY 0
#endif

#ifndef WBS_DELAY
#define WBS_DELAY 0
#endif

#ifndef WBU_DELAY
#define WBU_DELAY 0
#endif

#ifndef TRUE
#define TRUE 1
#define FALSE 0
#endif

#define CDDB_HOST	"cddb.cddb.com"
#define CDDB_PORT	888

/* Change this if you all ready have a directory containing your 
   CDDB records.  This will be changed into a dynamic setting
   in an upcoming release  
*/

#define CDDB_DIR	"~/.groovycd"

#define CONTINUE		0
#define REPEAT_TRACK	1
#define REPEAT_DISC	2
#define RANDOM_TRACK       3


void update_trackboard();
void exit_smoothly();

void play_cd( int start, int pos, int end) ;
void strmcpy (char **t, const char *s);
int eject_cd( void );
int cd_status( void );
void pause_cd( void );
void stop_cd( void );

void ncurses_init();

void print_number(int, int, char *, int);
void center(int, char *);
void draw_line(int, int, int);

int cddb_sum(int);
unsigned long cddb_discid(int);
void cddb_code();
int cddb_connect(char *, int);
void cddb_disconnect();
int cddb_login();
void cddb_query();
void default_track_info(int);
void cddb_readcdinfo(FILE *);

void show_help();
void hide_help();
