/*
 * MISC.C extace source file
 * 
 * /GDK/GNOME sound (esd) system output display program
 * 
 * Copyright (C) 1999 by Dave J. Andruczyk 
 * 
 * Based upon Code written by The Rasterman and DrMike from redhat.com
 * Re-hacked to look good by The Rasterman (Michael Fullbright)
 * 
 * This software comes under the GPL (GNU Public License)
 * You may freely copy,distribute etc. this as long as the source code
 * is made available for FREE.
 * 
 * No warranty is made or implied. You use this program at your own risk.
 */

#include <config.h>
#include <globals.h>
#include <protos.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/stat.h>
#include <unistd.h>
#include <fcntl.h>
#include <dirent.h>
#include <string.h>
#include <time.h>
#include <math.h>
#include <sys/ioctl.h>
#include <sys/time.h>
#include <gtk/gtk.h>
#include <gdk/gdkx.h>
#include <gdk_imlib.h>
#include <esd.h>
#ifdef HAVE_GSL_GSL_ERRNO_H
#include <gsl/gsl_errno.h>
#endif
#ifdef HAVE_GSL_ERRNO_H
#include <gsl_errno.h>
#endif 
#ifdef HAVE_GSL_GSL_FFT_REAL_H
#include <gsl/gsl_fft_real.h>
#endif
#ifdef HAVE_GSL_FFT_REAL_H
#include <gsl_fft_real.h>
#endif
#ifdef HAVE_LIBFFTW
#include <rfftw.h>
#endif 
#ifdef USE_ALSA
#include <sys/asoundlib.h>
#endif


// Globals
#ifdef HAVE_LIBFFTW
fftw_plan plan;                 // fft plan for fftw library
#endif

#ifdef USE_ALSA
#error ALSA defined!!!!
#define SND_PCM_LB_OPEN_PLAYBACK     0 
#define SND_PCM_LB_OPEN_RECORD       1 
#define SND_PCM_LB_STREAM_MODE_RAW     0 
#define SND_PCM_LB_STREAM_MODE_PACKET  1 
#ifdef USE_ALSA_VOID
void *alsa_handle;
#else   // New snd_pcm_t handles
snd_pcm_loopback_t *alsa_handle;
#endif
snd_pcm_format_t *format;
#endif


void open_sound(void)
{
#ifdef USE_ALSA
    int card = 0; // hardcoded, bad idea..
    int device = 0; // hardcoded, bad practice...
    int sub_chan = 0; // hardcoded, bad practice...
    int err = 0;
    format = g_malloc0(sizeof(snd_pcm_format_t));
#endif

    switch (sound_source)
    {
	case ESD:
	    sound=esd_monitor_stream(ESD_BITS16|ESD_STEREO|ESD_STREAM|ESD_MONITOR,RATE,NULL,"extace");
	    break;

#ifdef USE_ALSA
	case ALSA:
	    g_print("opening alsa device \n");
	    err = snd_pcm_loopback_open(&alsa_handle, card, device, sub_chan, SND_PCM_LB_OPEN_PLAYBACK);
	    if (err <0)
	    {
		fprintf(stderr, "open failed: %s\n", snd_strerror(err)); 
		exit (1);
	    }
	    alsa_fd = snd_pcm_loopback_file_descriptor(alsa_handle);
	    snd_pcm_loopback_stream_mode(alsa_handle, SND_PCM_LB_STREAM_MODE_RAW);
	    err = snd_pcm_loopback_format(alsa_handle, format);
	    if (err <0)
	    {
		fprintf(stderr, "format info failed: %s\n", snd_strerror(err)); 
		exit (1);
	    }
//	    g_print("rate %i, channels %i\n",format->rate, format->channels);
	    g_free(format);

	    break;
#endif
    }
/*    if (sound<0)
    {
	GtkWidget *box;
	GtkWidget *label;
	box = gtk_window_new(GTK_WINDOW_DIALOG);
	gtk_window_set_title(GTK_WINDOW(box),"ERROR!!!");
	label = gtk_label_new("Error, Cannot connect to Esound!!\n. PLease make sure \"esd\" is running.\n");
	gtk_container_add(GTK_CONTAINER(box), label);
	gtk_widget_show_all(box);

	gtk_signal_connect(GTK_OBJECT(box), "delete_event",
			   GTK_SIGNAL_FUNC(error_close_cb), NULL);
    }
    */

#ifdef HAVE_LIBFFTW
    plan = rfftw_create_plan(nsamp, FFTW_FORWARD, FFTW_ESTIMATE);
#endif
}

void error_close_cb(void)
{
      g_error("Cannot connect to sound daemon.");
      leave(NULL,NULL);
      
}

int GetFFT(void)
{
    gint buf;
    gint j;
    gshort *raw_ptr;
    gshort *mix_ptr;
    gdouble *data_win_ptr;
    gdouble *audio_left_ptr;
    gdouble *audio_right_ptr;
    gdouble *audio_data_ptr;
    gdouble *audio_data2_ptr;
    gdouble *fftp,*audio_end_ptr;
    gint nsamp_sqd;

    buf=((BUFS*2)+curbuf-lag)%BUFS;

#ifdef BUFFER_DEBUG
    g_print("buffer being processed is %i\n",buf);
#endif
    if (nsamp < 4096)
    {
	/* If less than 4096 points display goes too fast so do only every OTHER 	 * one...
	 */
	if ((curbuf%2)>0) 
	{
	    for (j=0;j<nsamp;j++)
	    {
		mixdown_buf[buf][j]=0.0;
	    }
	    return 0; 
	}
    }


    raw_ptr = incoming_buf[buf];	//<-- back to beginning
    mix_ptr = mixdown_buf[buf];		//<-- back to beginning
    data_win_ptr=datawindow;
    audio_data_ptr=audio_data;
    audio_left_ptr=audio_left;
    audio_right_ptr=audio_right;
    audio_end_ptr=audio_data_ptr+nsamp;
    while(audio_data_ptr<audio_end_ptr)
    {
	// for FFT
	*audio_data_ptr=((*data_win_ptr)*(double)*mix_ptr)/32768.0;
	// for scope
	*audio_left_ptr=((double)(*raw_ptr))/32768.0;
	raw_ptr++;
	*audio_right_ptr=((double)(*raw_ptr))/32768.0;
	raw_ptr++;
	mix_ptr++;
	audio_left_ptr++;
	audio_right_ptr++;
	audio_data_ptr++;
	data_win_ptr++;
    }

    if (mode==SCOPE) return 1;
#ifdef HAVE_LIBFFTW
    rfftw_one(plan, audio_data, raw_fft_out);
    norm_fft[0] = (raw_fft_out[0]*raw_fft_out[0])/(nsamp*nsamp);
    norm_fft[nsamp/2] = (raw_fft_out[nsamp/2]*raw_fft_out[nsamp/2])/(nsamp*nsamp);
    audio_data_ptr=raw_fft_out;
    audio_data2_ptr=raw_fft_out+nsamp-1;

#endif

#ifdef HAVE_LIBGSL 
#ifdef HAVE_LIBGSL4
    gsl_fft_real_radix2_transform(audio_data, nsamp, 1);
#endif
#ifdef HAVE_LIBGSLFFT
    gsl_fft_real_radix2(audio_data, nsamp);
#endif

    norm_fft[0] = (audio_data[0]*audio_data[0])/(nsamp*nsamp);
    norm_fft[nsamp/2] = (audio_data[nsamp/2]*audio_data[nsamp/2])/(nsamp*nsamp);

    audio_data_ptr=audio_data;
    audio_data2_ptr=audio_data+nsamp-1;
#endif

    /* take the log */
    audio_end_ptr=audio_data_ptr+nsamp;
    fftp=norm_fft;
    nsamp_sqd = nsamp*nsamp;
    while(audio_data_ptr<audio_end_ptr)
    {
	*fftp=8+log10((((*audio_data_ptr * *audio_data_ptr)+(*audio_data2_ptr * *audio_data2_ptr)))/(nsamp_sqd));
	if (*fftp<0) *fftp=0;
	fftp++;
	audio_data_ptr++;
	audio_data2_ptr--;
    }
    // Zero the buffer!!!
    for (j=0;j<nsamp;j++)
    {
	mixdown_buf[buf][j]=0.0;
    }
    for (j=0;j<nsamp*2;j++)
    {
	incoming_buf[buf][j]=0.0;
    }

    return 1;
}

gint main_disp_configure(GtkWidget *widget, GdkEventConfigure *event)
{
    if (win)
    {
	if ((width!=event->width)||(height!=event->height))
	{
	    width=event->width;
	    height=event->height;
	    if (pixmap)
		gdk_pixmap_unref(pixmap);
	    pixmap=gdk_pixmap_new(win,width,height,
				  gtk_widget_get_visual(disp)->depth);
	    gdk_draw_rectangle( pixmap,
				disp->style->black_gc,
				TRUE, 0,0,
				width,height);
	    gdk_window_set_back_pixmap(win,pixmap,0);
	    gdk_window_clear(win);
	}
	switch (mode)
	{
	    case (SPECGRAM):
		{
		    display_markers = 1;
		    break;
		}
	    default:
		break;
	}
    }

    return TRUE;
}

void update_time_markers()
{
    gint x=0;
    gint y=0;
    gint start = (gint)(spec_start*(float)width);
    gint space = (gint)((((float)(RATE)/(float)nsamp))*2.0*(float)tape_scroll);
    gdk_draw_rectangle( pixmap,
			disp->style->black_gc,
			TRUE, 0,height-time_border,
			width,time_border);
    
    for (x=start; x > 0; x-= space)
    {
	gdk_draw_line(pixmap,disp->style->white_gc,
		      x,height-time_border+3,x,height-time_border/2);
	for (y=1; y < 10;y++)
	{
	gdk_draw_line(pixmap,disp->style->white_gc,
		      x-(y*space/10),height-time_border+2,x-(y*space/10),height-time_border+6);
	}
    }
    gdk_window_clear(win);
}

void update_markers()
{
    int l_bord = (width * spec_start) + 3;
    int l_width = 10;
    int i = 0;
    gchar buff[10];
    gchar less_markers = 0;
    gint x1,x2,y1,y2;
    if(!ready)
	return;
    gdk_draw_rectangle( pixmap,
			disp->style->black_gc,
			TRUE, 0,0,
			width,height);
    if (height < 350)
	less_markers = 1;
    for (i = 1;i < (RATE/2/1000);i++) 
    {
	if ((less_markers) && ((i+1)%2))
	{
	    continue;
	}
	x1 = l_bord;
	y1 = (height - time_border) - ((float)i/22 * (height-time_border));
	x2 = x1 + l_width;
	y2 = y1;

	gdk_draw_line(pixmap,disp->style->white_gc,
		      x1,y1,x2,y2);

	g_snprintf(buff,10,"%i kHz",i);
	x2 += 3;
	y2 += gdk_text_height(disp->style->font,
			      buff,
			      strlen(buff))/2;
	gdk_draw_text(pixmap,disp->style->font,
		      disp->style->white_gc,
		      x2,y2,
		      buff,
		      strlen(buff));
    }
    gdk_window_clear(win);
}

gint main_disp_expose(GtkWidget *widget, GdkEventExpose *event)
{
    gdk_draw_pixmap(widget->window,
		    widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
		    pixmap,
		    event->area.x, event->area.y,
		    event->area.x, event->area.y,
		    event->area.width, event->area.height);

    return TRUE;
}

void handle_read(gpointer data, gint source, GdkInputCondition condition)
{   
    gint count = 0;
    if (last_is_full)
    {
	curbuf++;
	if(curbuf>=BUFS) 
	    curbuf = 0;
    }
    switch (sound_source)
    {
	case ESD:

	    count = read(sound, incoming_buf[curbuf] + pos/2, to_get); 
	    break;
	case ALSA:
	   // count = snd_pcm_loopback_read(alsa_handle, incoming_buf[curbuf] + pos/2, to_get);
	    break;
    }
    if (count < 0)
    {
	// should have a gracefull error instead of this!!!
	exit(1);
    }
    else
    {
	pos += count;
	to_get -= count;
    }
    if (to_get <= 0)
    {
	to_get = nsamp*2;
	pos = 0;
	last_is_full = 1;       // buffer full can crunch it now...
#ifdef BUFFER_DEBUG
	g_print("buffer number %i is full, DRAWING\n",curbuf);
#endif
	mixdown();
	draw();
    }
    else
    {
	last_is_full = 0;       // not full yet
#ifdef BUFFER_DEBUG
	g_print("buffer number %i is  NOT FULL\n",curbuf);
#endif
    }
}

void mixdown()
{
    int i=0;
    int j=0;
    int count=nsamp-1;
    while(count--)
    {
	mixdown_buf[curbuf][j] = ((incoming_buf[curbuf][i] + incoming_buf[curbuf][i++])/2);
	i++;
	j++;
    }
}
