#!/usr/bin/env python
#
#  $Id: fetchusa.py,v 1.8 1999/12/07 10:22:06 rob Exp $
#
#  Copyright 1998-1999 Rob Tillotson <robt@debian.org>
#  All Rights Reserved
#
#  Permission to use, copy, modify, and distribute this software and
#  its documentation for any purpose and without fee or royalty is
#  hereby granted, provided that the above copyright notice appear in
#  all copies and that both the copyright notice and this permission
#  notice appear in supporting documentation or portions thereof,
#  including modifications, that you you make.
#
#  THE AUTHOR ROB TILLOTSON DISCLAIMS ALL WARRANTIES WITH REGARD TO
#  THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
#  AND FITNESS.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY
#  SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
#  RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
#  CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
#  CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE!
#
"""Fetch a USA Today crossword puzzle from the web.
"""

__version__ = '$Id: fetchusa.py,v 1.8 1999/12/07 10:22:06 rob Exp $'

__copyright__ = 'Copyright 1998-1999 Rob Tillotson <robt@debian.org>'

import Pyrite
import Pyrite.App.XWord
from Pyrite.Application import Application

import StringIO

import urllib

import string, sys, time

usa_today_url = 'http://www.usatoday.com/life/puzzles/'

def fetch(y,m,d):
    if y >= 100: y = y % 100
    puz = 'ut%02d%02d%02d.puz' % (y, m, d)
    pdb = 'ut%02d%02d%02d.pdb' % (y, m, d)
    subdir = '%02d%02d' % (y, m)
    url = usa_today_url + subdir + '/' + puz

    print 'Getting ', url
    u = urllib.urlopen(url)
    f = open(puz, 'w')
    f.write(u.read())
    f.close()
    p = Pyrite.App.XWord.Record()
    p.read_usa_today(open(puz))

    if len(p['name']) > 31: n = p['name'][:31]
    else: n = p['name']
    f = Pyrite.createFile(pdb, {'name': n, 'type':'DATa', 'creator':'XWrd'})
    f.addRecord(p)
    

def fetch_range(y0, m0, d0, y1, m1, d1):
    t0 = int(time.mktime((y0, m0, d0, 0, 0, 0, 0, 0, 0)))
    t1 = int(time.mktime((y1, m1, d1, 0, 0, 0, 0, 0, 0)))

    while t0 <= t1:
	tu = time.gmtime(t0)
	sys.stdout.write('%s ... ' % time.strftime('%A, %B %d, %Y', tu))
	if tu[6] < 5:  # puzzles only on monday through friday
	    fetch(tu[0], tu[1], tu[2])
	    sys.stdout.write('fetched.\n')
	else:
	    sys.stdout.write('no puzzle.\n')
	t0 = t0 + (60*60*24)
	
# Command line arguments:
#   fetchusa [-r <date0>] <date1> ...
#
# If -r is supplied, gets all puzzles frmo <date0> to <date1> inclusive.
# If not, just gets all of the dated puzzles.

def main(args):
    import getopt

    optlist, args = getopt.getopt(args, 'r:')

    startdate = None
    
    for o, v in optlist:
	if o == '-r':
	    startdate = v

    if startdate:
	m0, d0, y0 = tuple(map(string.atoi,string.split(startdate, '/')))
	m, d, y = tuple(map(string.atoi,string.split(args[0], '/')))
	fetch_range(y0, m0, d0, y, m, d)
    else:
	for x in args:
	    m, d, y = string.split(args[0], '/')
	    fetch(y, m, d)
	    

class App(Application):
    def run(self, argv):
	if len(argv) < 2:
	    print "Must give two arguments (start and end dates)."
	    sys.exit(1)

	m0, d0, y0 = tuple(map(string.atoi, string.split(argv[0], '/')))
	m, d, y = tuple(map(string.atoi, string.split(argv[1], '/')))

	p = self.get_plugin('App','XWord')
	st = self.get_plugin('Store','Directory')('.')
	print st
	
	t0 = int(time.mktime((y0, m0, d0, 0, 0, 0, 0, 0, 0)))
	t1 = int(time.mktime((y, m, d, 0, 0, 0, 0, 0, 0)))

	while t0 <= t1:
	    tu = time.gmtime(t0)
	    print "%s ..." % time.strftime('%A, %B %d, %Y', tu),
	    if tu[6] < 5: # skip sunday and monday
		y, m, d = tu[:3]
		if (y >= 100): y = y % 100
		puz = 'ut%02d%02d%02d.puz' % (y, m, d)
		pdb = 'ut%02d%02d%02d.pdb' % (y, m, d)
		subdir = '%02d%02d' % (y, m)
		url = usa_today_url + subdir + '/' + puz
		print url, "...",
		u = urllib.urlopen(url)
		sio = StringIO.StringIO(u.read())
		#open(puz,'w').write(u.read())

		# you should never actually do this.
		rec = Pyrite.App.XWord.Record()
		try:
		    rec.read_usa_today(sio)
		except:
		    print "no puzzle???"
		else:
		    db = p.create(st, rec['name'][:31], filename=pdb)
		    db.append(rec)
		    db.close()

		    print "fetched."
	    else:
		print "no puzzle."
	    t0 = t0 + (60*60*24)
	    
if __name__ == '__main__':
    a = App()
    a()
    
