#
#  $Id: File.py,v 1.8 1999/12/11 12:35:12 rob Exp $
#
#  Copyright 1999 Rob Tillotson <robt@debian.org>
#  All Rights Reserved
#
#  Permission to use, copy, modify, and distribute this software and
#  its documentation for any purpose and without fee or royalty is
#  hereby granted, provided that the above copyright notice appear in
#  all copies and that both the copyright notice and this permission
#  notice appear in supporting documentation or portions thereof,
#  including modifications, that you you make.
#
#  THE AUTHOR ROB TILLOTSON DISCLAIMS ALL WARRANTIES WITH REGARD TO
#  THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
#  AND FITNESS.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY
#  SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
#  RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
#  CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
#  CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE!
#
"""A Store that only contains a single file.

This type of Store simulates the normal Store API as much as is
possible using only a single, named local file.  It is probably
not wise to expect too much from this particular Store, since it
is mainly meant as a simple way to access single, user-specified
files using the Store API.  (For example, an installer might want
to use the 'copy' method on it, or something.)
"""

__version__ = '$Id: File.py,v 1.8 1999/12/11 12:35:12 rob Exp $'

__copyright__ = 'Copyright 1999 Rob Tillotson <robt@debian.org>'


import os, time

import Pyrite
import Pyrite.Store

from Pyrite import Database, pdbfile, _

from Pyrite import prc

class FileStore(Pyrite.Store.BaseStore):
    properties = ('read','create','delete','list')
    db_properties = ('id-unique','id-replace')
    
    def __init__(self, filename = ''):
	Pyrite.Store.BaseStore.__init__(self)
	self.filename = filename

    def _open(self, name, mode="rs", properties=()):
	try:
	    f = prc.File(self.filename, read=1, write=(('w' in mode) and 1 or 0))
	    i = f.getDBInfo()
	    return (f, i, mode, self.db_properties)
	except:
	    raise IOError, _("no such database")
	
    def _create(self, name, creator, type, flags=0, version=1, filename=None,
		info = None, **kw):
	if flags is None: flags = 0
	i = { 'name': name,
	      'creator': creator,
	      'type': type,
	      'index': 0,
	      'more': 0,
	      'modnum': 0,
	      'version': version,
	      'createDate': int(time.time()),
	      'modifyDate': int(time.time()),
	      'backupDate': 0,
	      }
	i.update(pdbfile.flags_to_info(flags))
	if info is not None: i.update(info)
	if len(i['name']) > 31: i['name'] = i['name'][:31]

	f = prc.File(self.filename, 0, 1, info)
	info = f.getDBInfo()
	return (f, info, 'rws', self.db_properties)

    def delete(self, name):
	os.unlink(self.filename)

    def info(self, name):
	try:
	    f = prc.File(self.filename, read=1, write=0)
	    return f.getDBInfo()
	except:
	    raise IOError, _("no such database")

    def list(self):
	try:
	    i = self.info(None)
	    return [ i['name'] ]
	except:
	    return []

    def listinfo(self, name=None, creator=None, type=None):
	try:
	    i = self.info(None)
	    if name is not None and i['name'] != name: return []
	    if creator is not None and i['creator'] != creator: return []
	    if type is not None and i['type'] != type: return []
	    return [i]
	except:
	    return []
	
class Store(Pyrite.Store.Store):
    name = 'File'
    author = Pyrite.author
    version = Pyrite.version
    description = _("A single PRC/PDB file.")
    properties = ['read','create','delete','list']

    store_class = FileStore
