#
#  $Id: Text.py,v 1.1 1999/05/27 09:30:49 rob Exp $
#
#  Copyright 1999 Rob Tillotson <robt@debian.org>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU Library General Public License, version 2,
#  as published by the Free Software Foundation.
#
#  This program is distributed in the hope that it will be useful, but
#  WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#  Library General Public License for more details.
#
#  You should have received a copy of the GNU Library General Public License
#  along with this program; if not, write the Free Software Foundation,
#  Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
#
"""
"""

__version__ = '$Id: Text.py,v 1.1 1999/05/27 09:30:49 rob Exp $'

__copyright__ = 'Copyright 1999 Rob Tillotson <robt@debian.org>'

import formatter, string

import DTKInput

class TextDTKInput(DTKInput.DTKInput):
    name = 'Text'
    version = '1.1.0'
    author = 'Rob Tillotson <robt@debian.org>'
    url = ''
    description = 'Text input, with paragraph reflowing.'

    def convert(self, f, w):
	fmt = formatter.AbstractFormatter(w)
	in_para = 0

	while 1:
	    l = f.readline()
	    if not l: break

	    if not string.strip(l):
		if in_para:
		    in_para = 0
		    fmt.end_paragraph(1)
	    else:
		in_para = 1
		fmt.add_flowing_data(l)
		    
