#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "varman.h"
#include "configfile.h"

/* uncomment for debugging */
/* #define DEBUG */

typedef struct
{
   varman_varchanged callback;
   gpointer data;
} varman_varchanged_cbinfo;

varman_database *varman_vardatabase_create_new(int maxentries)
{
	varman_database *db;
	
	db=(varman_database*)malloc(sizeof(varman_database));
	
	db->varlist=(VARMAN_VAR_ENTRY*)malloc(sizeof(VARMAN_VAR_ENTRY)*maxentries);
	db->entries=0;
	db->maxentries=maxentries;
	
	return db;
}
;

varman_database *varman_vardatabase_create_fromfile(int maxentries,char *name,char *section)
{
	varman_database *db;
	
	db=(varman_database*)malloc(sizeof(varman_database));
	
	db->varlist=(VARMAN_VAR_ENTRY*)malloc(sizeof(VARMAN_VAR_ENTRY)*maxentries);
	db->entries=0;
	db->maxentries=maxentries;

	varman_loaddatabase(db,name,section);
	
	return db;
}
;

/* install a change_callback function for a variable */
void varman_install_handler(varman_database *db,
			    char *name,
			    varman_varchanged handler,
			    gpointer data
			    )
{
	int pos;
   	varman_varchanged_cbinfo *info;
   	
   	info=(varman_varchanged_cbinfo*)malloc(sizeof(varman_varchanged_cbinfo));
   	info->callback=handler;
   	info->data=data;   
		
	/* see,if there already is an entry */
	pos=varman_getentrynumber(db,name); 
	if ((db->entries>=db->maxentries) && (pos==-1))
	  {
		  printf ("out of memory error allocating runtime vars...\n");
		  exit(1);
	  }
	;
	if (pos==-1)	/* if not,create new one */
	  { 
		  pos=db->entries;
		  db->entries++;
		  
		  db->varlist[pos].callbacks=NULL;           /* no callbacks yet */
		  strcpy(db->varlist[pos].varvalue,"");      /* no value yet */
		  strcpy(db->varlist[pos].varname,name);     /* set name at least */
	  }
	;
	db->varlist[pos].callbacks=g_list_append(db->varlist[pos].callbacks,
						 (gpointer)info);
	
}
;

void varman_remove_handler(varman_database *db,
			   char *name,
			   varman_varchanged handler,
			   gpointer data)
{
   int pos;
   varman_varchanged_cbinfo *info;
   GList *current;		

   /* see,if there is an entry */
   pos=varman_getentrynumber(db,name); 
   if (pos==-1) return; /* simply do nothing if theres no matching var */   

   current=db->varlist[pos].callbacks;
   while (current!=NULL)
     {
	info=(varman_varchanged_cbinfo*)current->data;
	/* get the next entry here because the reference might already be
	 * destroyed below */
	current=current->next;
	if (((info->callback==handler)||(handler==NULL)) &&
	    ((info->data==data)||(data==NULL)))
	  {
	     db->varlist[pos].callbacks=
	       g_list_remove(db->varlist[pos].callbacks,(gpointer)info);
	     free(info);
	  };
     };
}
;
	
/* callback handler for "foreach" statement */
void varman_cb_handler(gpointer data,gpointer userdata)
{
	VARMAN_VAR_ENTRY *var;
   	varman_varchanged_cbinfo *info;
	
        info=(varman_varchanged_cbinfo*)data;
	var=(VARMAN_VAR_ENTRY*)userdata;
	
	info->callback(var,info->data);
}
;		

void varman_setvar(varman_database *db,char *name,char *value)
{
	int pos;
	
	
	/* see,if there already is an entry */
	pos=varman_getentrynumber(db,name); 
	if ((db->entries>=db->maxentries) && (pos==-1))
	  {
		  printf ("out of memory error allocating runtime vars...\n");
		  exit(1);
	  }
	;
	if (pos==-1)	/* if not,create new one */
	  { 
		  pos=db->entries;
		  db->entries++;
		  
		  db->varlist[pos].callbacks=NULL; /* no callbacks yet */
		  strcpy(db->varlist[pos].varname,name);
	  }
	;
	if (strcmp(db->varlist[pos].varvalue,value))
	  {
		  strcpy(db->varlist[pos].varvalue,value);
		  
		  g_list_foreach(db->varlist[pos].callbacks, /* process callbacks */
				 varman_cb_handler,
				 (gpointer)&db->varlist[pos]);
	  }
	; /* do only call callback if value has definitely changed */
}
;

/* this one had to be renamed utterly as there is no function overlay support
 * in normal c. former vardatabase::setvar(char *name,float value); */
void varman_setvar_value(varman_database *db,char *name,float value)
{
	char tmp[255];
   	if (value==(int)value)
           sprintf((char*)&tmp,"%.0f",value);
        else     
           sprintf((char*)&tmp,"%f",value);
	varman_setvar(db,name,(char*)&tmp);
}
;
	

char *varman_getvar(varman_database *db,char *name)
{
	int pos;
	
	pos=varman_getentrynumber(db,name);
	if (pos!=-1) return (char*)&db->varlist[pos].varvalue;
	        else return NULL;
}
;

float varman_getvar_value(varman_database *db,char *name)
{
   float result;
   char *var;
   
   var=varman_getvar(db,name);
	   
   if (var!=NULL)     
     sscanf(varman_getvar(db,name),
	    "%f",&result);
   else
     result=0;
   
   return result;
};


char *varman_getnamebyvalue(varman_database *db,char *value)
{
	int pos;
	
	pos=varman_getentrynumberbyvalue(db,value);
	if (pos!=-1) return (char*)&db->varlist[pos].varname; 
	        else return NULL;
}
;

/* replace variable in String by its value. this is a generic function
 * not using any var database. variable name and value are given as
 * parameters directly */
void varman_replacestring(char *string,char *varname,char *svarval) 
{
	char *rest;
	
	rest=(char*)malloc(VARMAN_MAXSTRINGSIZE);
	while (strstr(string,varname)!=NULL)
	  {
		  strcpy(rest,strstr(string,varname)+strlen(varname));
		  strcpy(strstr(string,varname),svarval);
		  if ((strlen(string)+strlen(rest))>VARMAN_MAXSTRINGSIZE-1)
		    {
			    printf ("varman.c: stringsize overflow\n");
			    exit(-1);
		    }
		  ;		      
		  strcat(string,rest);
	  }
	;	
	free(rest);
}
;

/* see above,takes float as argument */
void varman_replacestringbyfloat(char *string,char *varname,float varvalue)
{
	char *tmp;
	
	tmp=(char*)malloc(255);
        if (varvalue==(int)varvalue)
           sprintf(&tmp[0],"%.0f",varvalue);
   	else
           sprintf(&tmp[0],"%f",varvalue);
	varman_replacestring(string,varname,tmp);
	
	free(tmp);
}
;


/* basic functionality see above, this one is used for replacing variables in 
 * computed terms,automatically inserting brackets around the expression */
void varman_replacevarbyvalue(char *string,char *varname,char *svarval) 
{
	char *tmp;
	
	tmp=(char*)malloc(255);
	strcpy(tmp,"(");
	strcpy(&tmp[1],svarval);
	strcat(tmp,")");
	varman_replacestring(string,varname,tmp);
	
	free(tmp);
}
;

/* see above, only difference: float value instead of value as string.
 * naming changed due to c limitations */
void varman_replacevarbyvalue_float(char *string,char *varname,float varvalue) 
{
	char *tmp;
	
	tmp=(char*)malloc(255);	
	strcpy(tmp,"(");
	sprintf(&tmp[1],"%f",varvalue);
	strcat(tmp,")");
	varman_replacestring(string,varname,tmp);
	
	free(tmp);
}
;

/* Replace whatever looks like a var in the current string */
void varman_replacevars(varman_database *db,char *string) 
{
	int i;
	for (i=0;i<db->entries;i++)
	  {
		  varman_replacestring(string,
				       db->varlist[i].varname,
				       db->varlist[i].varvalue);
	  }
	;
}
;

/* Replace whatever looks like a var 
 * in the current string by its value in brackets */
void varman_replacevarsbyvalue(varman_database *db,char *string)
{
	int i;
	for (i=0;i<db->entries;i++)
	  {
		  varman_replacevarbyvalue(string,db->varlist[i].varname,db->varlist[i].varvalue);
	  }
	;
}
;


int varman_getentrynumber(varman_database *db,char *name)
{
	int pos=-1;
	int i;
	
	for (i=0;(i<db->entries)&&(pos==-1);i++)
	  {
		  if (!strcmp(db->varlist[i].varname,name)) pos=i;
	  }
	;
	return pos;
}
;

int varman_getentrynumberbyvalue(varman_database *db,char *value)
{
	int pos=-1;
	int i;
	
	for (i=0;(i<db->entries)&&(pos==-1);i++)
	  {
		  if (!strcmp(db->varlist[i].varvalue,value)) pos=i;
	  }
	;
	return pos;
}
;

char *varman_getvar_copy(varman_database *db,char *name)
{
	char *var,*varval;
	varval=varman_getvar(db,name);
	var=(char*)malloc(VARMAN_MAXSTRINGSIZE);
	if (varval!=NULL)
	  {		  
	    if (strlen(varval)>VARMAN_MAXSTRINGSIZE-1)
		    {			    
			    printf ("Stringsize overflow.\n");
			    printf ("Please recompile Gtoaster with VARMAN_MAXSTRINGSIZE set \n");
			    printf ("to a higher value.\n");
			    exit(-1);
		    }
		  ;
	    strcpy(var,varval);
	  }	
	else
	    strcpy(var,"");		
	return var;
}
;

char *varman_getnamebyvalue_copy(varman_database *db,char *value)
{
	char *var,*varname;
	varname=varman_getnamebyvalue(db,value);
	var=(char*)malloc(VARMAN_MAXSTRINGSIZE);
	if (varname!=NULL)
	    strcpy(var,varname);
	else 
	    strcpy(var,"");
	return var;
}
;

char *varman_replacestring_copy(char *string,char *varname,char *svarval)
{
	char *result;
	result=(char*)malloc(VARMAN_MAXSTRINGSIZE);
	strcpy(result,string);
	varman_replacestring(result,varname,svarval);	
	return result;
}
;
	
char *varman_replacevarbyvalue_copy(char *string,char *varname,char *svarval)
{
	char *result;
	result=(char*)malloc(VARMAN_MAXSTRINGSIZE);
	strcpy(result,string);
	varman_replacevarbyvalue(result,varname,svarval);	
	return result;
}
;

char *varman_replacevarbyvalue_float_copy(char *string,char *varname,float varvalue)
{
	char *result;
	result=(char*)malloc(VARMAN_MAXSTRINGSIZE);
	strcpy(result,string);
	varman_replacevarbyvalue_float(result,varname,varvalue);	
	return result;
}
;

char *varman_replacevars_copy(varman_database *db,char *string)
{
	char *result;
	result=(char*)malloc(VARMAN_MAXSTRINGSIZE);
	strcpy(result,string);
	varman_replacevars(db,result);
	return result;
}
;

char *varman_replacevarsbyvalue_copy(varman_database *db,char *string)
{
	char *result;
	result=(char*)malloc(VARMAN_MAXSTRINGSIZE);
	strcpy(result,string);
	varman_replacevarsbyvalue(db,result);
	return result;
}
;

int varman_loaddatabase(varman_database *db,char *filename,char *section)
{
	FILE *f;
	char name[VARMAN_MAXSTRINGSIZE],value[VARMAN_MAXSTRINGSIZE];
   	int success=0;
	
	f=fopen(filename,"r");
	if (f!=NULL)
	  {
		  if (configfile_seeksection(f,section))
		    {			    
			    do
			      {
				      configfile_getnextentry(f,(char*)&name,(char*)&value);
				      if (strlen((char*)&name)>0)
					{				      
						varman_setvar(db,(char*)&name,(char*)&value);
					   	success=1;
					}
				      ;
			      }
			    while (strlen((char*)&name)>0);
		    }
		  ;
		  fclose(f);
	  }
	;
   return success;
}
;

/* this function can be used as a callback for configfile.c without
 * modifications */
void varman_savedatabase_fd(FILE *fd,varman_database *db)
{
	int x;		
	
	for (x=0;x<db->entries;x++)
	  {
		  fprintf(fd,"%s=%s\n",
			  (char*)&db->varlist[x].varname,
			  (char*)&db->varlist[x].varvalue);
	  }
	;	
}
;

void varman_savedatabase(varman_database *db,char *filename,char *section)
{
	FILE *f;
	
	f=fopen(filename,"w+");
	if (f!=NULL)
	  {		  
		  fprintf (f,"%s\n",section);
		  varman_savedatabase_fd(f,db);
		  fclose(f);
	  }
	;
}
;

