/* this file implements gnometoasters preview function which can be used
 * to listen to audio tracks prior to writing them to a cd,be it to test
 * wether the track sounds properly or just to determine if it is the right
 * track at all. This widget primarily works as a drop destination where
 * tracks to be previewed are dropped. Additionally,it implements
 * a button to stop a tracks preview if it is no longer needed.
 * 
 * It is intended to support a variety of output devices with a driver-based
 * concept. That means,that well have to create a driver database for audio
 * output,supporting at least esd and dsp from the very beginning.
 * 
 * concerning docking position,we should possibly allow it to float around freely
 * if gnome support is enabled,perhaps giving it the layout of a proper
 * media player if dragged outside Gnometoasters main window */

#include <gtk/gtk.h>
#include <string.h>
#include <errno.h>

#include "int.h"

#include "main.h"
#include "tracks.h"
#include "preview.h"
#include "dndsetup.h"
#include "fileman.h"
#include "dircache.h"
#include "stdfiletrack.h"
#include "streams.h"
#include "audio.h"
#include "helpings.h"
#include "cddrives.h"

#include "playtrack.xpm"
#include "stopplayer.xpm"

/* uncomment for debugging */
/* #define DEBUG */

#define PREVIEW_PLAYBUFFER 16384

/* record.c checks this var before it initiates the writing process
 * as the precious timing necessary for a flawless writing procedure
 * is likely to be disturbed by the playing process */
int preview_player_active=0;

GtkWidget *icon_playtrack;
GtkWidget *icon_stopplayer;

preview_infostruct preview_info;


void preview_stopplay(GtkWidget *w,
		      preview_infostruct *info)
{
   /* if in playing mode */
   if (info->currenttrack!=NULL)
     {
	#ifdef DEBUG
	 printf ("preview_stopplay: removing input_watch\n");
	#endif
	if (info->fdwatch!=-1)
	  gdk_input_remove(info->fdwatch);
		
	#ifdef DEBUG
	 printf ("preview_stopplay: closing track\n");
	#endif
	if (info->input!=-1)
	  tracks_closepipe(info->currenttrack);	
	#ifdef DEBUG
	 printf ("preview_stopplay: closing audio driver\n");
	#endif
	if (info->output!=-1)
	  audio_close(info->driver); 
	
	#ifdef DEBUG
	 printf ("preview_stopplay: unclaiming track\n");
	#endif
	tracks_unclaim(info->currenttrack);
	
	info->currenttrack=NULL;
	info->fdwatch=-1;
	info->input=-1;
	info->output=-1;
	

	/* change icon of the preview player button */	
	gtk_widget_show(icon_playtrack);	
	gtk_widget_hide(icon_stopplayer);

        preview_player_active=0;
     };
};

void preview_pushdata(gpointer data,
		      gint source,
		      GdkInputCondition condition)
{
   preview_infostruct *info;
   char buf[PREVIEW_PLAYBUFFER];
   int readcount;
   
   info=(preview_infostruct*)data;
   
   readcount=read(info->input,&buf,PREVIEW_PLAYBUFFER);
   if (readcount>0)
	write(info->output,&buf,readcount);
   /* shut down the player once the input stream is done */
   if (!readcount)
     preview_stopplay(info->button,info);
};


int preview_droptrack(char *s,char *p)
{
   preview_infostruct *info;
   
   info=(preview_infostruct*)p;
   
   #ifdef DEBUG
    printf ("preview_droptrack: check if another track is in process\n");
   #endif
   /* if were currently playing a track,stop it before starting a new one */
   if (info->currenttrack!=NULL)
     preview_stopplay(info->button,info);

   /* distinguish between real tracks and files that have to be 
    * converted first */
   if (!strncmp("stream:",s,7))
     {	
   #ifdef DEBUG
    printf ("preview_droptrack: found normal track stream\n");
   #endif
	info->currenttrack=streams_getstreambyid((char*)(strchr(s,':')+1));
	/* claim if valid only */
	if (info->currenttrack!=NULL)
	  tracks_claim(info->currenttrack);
     };
   if ((!strncmp("file:",s,5))&&(!dircache_isdir((char*)(strchr(s,":"[0])+1))))
     {
   #ifdef DEBUG
    printf ("preview_droptrack: found file,executing file2track conversion\n");
   #endif
	info->currenttrack=stdfiletrack_create((char*)(strchr(s,':')+1));
     };

   /* just ignore everything that is neither stream nor file... 
    * also ignore streams that came from outside as long as they arent
    * substituted with some kind of "remote track" type in 
    * streams_getstreambyid */
   if (info->currenttrack!=NULL)
     {	

	/* play audio tracks only */

	if (!strcmp(info->currenttrack->tracktype,"audio"))
	  {	   
	     /* get the audio device currently responsible for output */
	     info->driver=audio_getdriver_default;   
	
	     /* change icon of the preview player button */
	     gtk_widget_show(icon_stopplayer);
	     gtk_widget_hide(icon_playtrack);
	     
	     preview_player_active=1;		  

#ifdef DEBUG
	     printf ("preview_droptrack: opening audio driver ");
#endif
	     /* open audio device */
	     info->output=audio_open(info->driver);
#ifdef DEBUG
	     printf ("(result=%i)\n",info->output);
	     printf ("preview_droptrack: opening audio track ");
#endif
	     /* open track */
	     info->input=tracks_openpipe(info->currenttrack);

#ifdef DEBUG
	     printf ("(result=%i)\n",info->input);
	     printf ("preview_droptrack: installing data forwarding handler\n");
#endif
	     if ((info->output!=-1)&&(info->input!=-1))
	       {		  
		  info->fdwatch=gdk_input_add(info->output,
					      GDK_INPUT_WRITE,
					      preview_pushdata,
					      (gpointer)info);
	       }
	     else
	       {		  
#ifdef DEBUG
		  perror ("preview_droptrack: couldn't open stream or audio device busy\n");
#endif
		  preview_stopplay(info->button,info);
	       };
	  }
	else
	  {	     
#ifdef DEBUG
	     printf ("preview_droptrack: not playing non-audio track\n");
#endif
	     preview_stopplay(info->button,info);
	  };
     }
   else
     {
#ifdef DEBUG
	printf ("preview_droptrack: couldnt get valid track structure\n");
#endif
     };
   return 1;
};   

/* process drops */
void preview_droptracks(gchar *selection,preview_infostruct *info)
{
   fileman_selectionhandler(selection,(char*)info,
			    preview_droptrack);
};

void preview_drophandler(GtkWidget *w,
			 GdkDragContext *c,
			 gint x,gint y,
			 GtkSelectionData *data,
			 guint inf,
			 guint time,
			 preview_infostruct *info)
{
   if ((data->length>=0)&&(data->format==8))
     {
	preview_droptracks((gchar*)data->data,info);
	gtk_drag_finish(c,TRUE,FALSE,time);
	return;
     };
   gtk_drag_finish(c,FALSE,FALSE,time);
};

/* use this interface to initiate track playing from other parts of 
 * Gnometoaster 
 * The second parameter is the media player infostruct. It usually points
 * to preview_info at the moment,so youre probably ok if you just
 * give it &preview_info there */
void preview_playtrack(char *trackname,preview_infostruct *info)
{
   #ifdef DEBUG
     printf ("preview_playtrack: dropping track %s\n",trackname);	
   #endif
     preview_droptrack(trackname,(char*)info);
};

void preview_create()
{
   GdkPixmap *xpm;
   GdkBitmap *mask;
   GtkStyle  *style;
   
   style=gtk_widget_get_style(window);
   xpm=gdk_pixmap_create_from_xpm_d(window->window,&mask,
				    &style->bg[GTK_STATE_NORMAL],
				    playtrack_xpm
				    );
   icon_playtrack=gtk_pixmap_new(xpm,mask);
   xpm=gdk_pixmap_create_from_xpm_d(window->window,&mask,
				    &style->bg[GTK_STATE_NORMAL],
				    stopplayer_xpm
				    );
   icon_stopplayer=gtk_pixmap_new(xpm,mask);
      
   preview_info.button=gtk_button_new();
   preview_info.iconholder=gtk_vbox_new(0,0);   
   gtk_container_add(GTK_CONTAINER(preview_info.button),
		     preview_info.iconholder);
   gtk_widget_show(preview_info.iconholder);
   gtk_widget_show(preview_info.button);
   main_settip(preview_info.button,_("Drag files/tracks to be previewed here"));

   /* add both icons to the button but show only one of them at a time */
   gtk_box_pack_start(GTK_BOX(preview_info.iconholder),icon_playtrack,0,0,0);
   gtk_box_pack_start(GTK_BOX(preview_info.iconholder),icon_stopplayer,0,0,0);   
   gtk_widget_show(icon_playtrack);
   
   /* register preview widget as drop destination */
   dndsetup_drop(preview_info.button,
		 GTK_SIGNAL_FUNC(preview_drophandler),
		 &preview_info);
   	
   gtk_signal_connect(GTK_OBJECT(preview_info.button),"clicked",
		      GTK_SIGNAL_FUNC(preview_stopplay),&preview_info);
   
   gtk_box_pack_end(GTK_BOX(downbox),preview_info.button,0,0,0);   

   preview_info.currenttrack=NULL;
   preview_info.fdwatch=-1;
   preview_info.input=-1;
   preview_info.output=-1;
};

   
   
   
   
