
#ifndef PREFERENCES_H
#define PREFERENCES_H

#include <gtk/gtk.h>

#include "varman.h"

void preferences_init();
void preferences_save();
/* any handler passed to this function is called if either OK or Apply is
 * clicked by the user. This will generally be used by varmanwidgets to
 * update their variables */
void preferences_setapplyhandler(GtkSignalFunc,gpointer);
/* any handler passed to this function is called after values entered
 * in the preferences setup have become invalid because the user has  
 * clicked the cancel button */
void preferences_setundohandler(GtkSignalFunc,gpointer);
/* remove a apply or undo handler */
void preferences_removeapplyhandler_by_data(gpointer);
void preferences_removeundohandler_by_data(gpointer);
void preferences_removeapplyhandler_by_func(GtkSignalFunc);
void preferences_removeundohandler_by_func(GtkSignalFunc);

extern GtkWidget *preferences_editmain; /* use this to show preferences */
extern GtkWidget *preferences_editpad;  /* use this to add pages */
extern GtkWidget *preferences_common; 

#define MAX_GLOBAL_DEFS 256
extern varman_database *global_defs;
#define MAX_DYNAMIC_DEFS 20
extern varman_database *dynamic_defs;

/* becomes true whenever no configuration file could be found */
extern int preferences_freshinstall;
/* set this to false if you don't want your settings to be saved */
extern int preferences_saveonexit;

#define FSEDIT_DESTPATH varman_getvar(global_defs,"fsedit_destpath")
#define TEMPDIR varman_getvar(global_defs,"tempdir")
#define RECORDER varman_getvar(global_defs,"recorder")

/* currently cannot be changed at runtime */
#define BUFSIZE 2048

/* the maximum length a directory path can be */
#define MAXPATHLENGTH 4096

/* maximum standard string size */
#define MAXSTRINGSIZE 1024

#endif // PREFERENCES_H
