/* This file tracks all the changes in gnometoaster's default
 * configuration and warns the user if essential facts have changed */

#include <gtk/gtk.h>

#include "preferences.h"
#include "varman.h"
#include "dialog.h"
#include "filetypes.h"

#include "defaultentries.h"

#define currentversion varman_getvar_value(global_defs,"configfile_version")
#define update(minversion,description,performer) \
        if (currentversion<minversion) dialog_question(description,performer,NULL)


/* this is the current config file version */
#define CONFIG_VERSION 3

void configupdate_to1(gint execute,gpointer data)
{
   if (execute==DIALOG_YES)
     {	
	varman_setvar(global_defs,
		      "rec_writetrack",
		      DEFAULTENTRIES_REC_WRITETRACK
		      );
	varman_setvar(global_defs,	
		      "rec_fixate",
		      DEFAULTENTRIES_REC_FIXATE
		      );
	varman_setvar(global_defs,
		      "rec_cleardisc",
		      DEFAULTENTRIES_REC_CLEARDISC
		      );
     };
};

/* started Nov. 20th */
void configupdate_to3(gint execute,gpointer data)
{
   if (execute==DIALOG_YES)
     {
	filetypes_modify(filetypes_getfiletypehandler(".mp3"),
			 NULL,
			 NULL,
			 -1,
			 NULL,
			 DEFAULTENTRIES_EXEC_MPG123,
			 NULL,
			 NULL
			 );
	varman_setvar(global_defs,
		      "isotrack_client",
		      DEFAULTENTRIES_ISOTRACK_CLIENT
		      );
	varman_setvar(global_defs,
		      "isotrack_client_ms",
		      DEFAULTENTRIES_ISOTRACK_CLIENT_MS
		      );
     };
};

/* started Oct 19th */
void configupdate_to2(gint execute,gpointer data)
{
   if (execute==DIALOG_YES)
     {	
	varman_setvar(global_defs,
		      "isotrack_client",
		      DEFAULTENTRIES_ISOTRACK_CLIENT
		      );
     };
};

void configupdate_confignewerthanexe(gint execute,gpointer data)
{
   if (execute==DIALOG_NO)
     {
	/* don't save settings */
	preferences_saveonexit=0;
	/* exit gnometoaster as soon as it enters the main loop */
	gtk_main_quit();
     };
};

void configupdate_run()
{
   /* if updating from an older version */
   if (!preferences_freshinstall)
     {
	if (CONFIG_VERSION<currentversion)
	  {
	     dialog_question("A Configfile for a newer version\n"		      
			     "of Gnometoaster was found.\n"
			     "Continuing may be dangerous because\n"
			     "of possible changes in the file\n"
			     "structure which may destroy your\n"
			     "entire configuration.\n"
			     "Do you want to run Gnometoaster anyway ?\n",
			     configupdate_confignewerthanexe,NULL);
	  };	
	update(1,"Introducing multisession toc and dummy write\n"
	         "functionality into gnometoaster requires a few\n"
	         "modifications in gnometoaster's configuration setup\n"	       
	         "I can do the necessary modifications\n"
                 "automatically.You will lose\n"
	         "your customized configuration\n"
	         "of \"Preferences/Recorder/Trackwrite command\",\n"
	         "\"Preferences/Recorder/Fixating Command\"\n"
	         "and \"Preferences/Recorder/Clear Disc\"\n"
	         "If you want to modify those entries yourself,\n"
	         "just answer NO to this question.\n"
	         "(New Variables rec_multisession,rec_dummymode)\n",
		configupdate_to1);
	update(2,"This version of Gnometoaster switches the underlying\n"
	         "filesystem creator from mkhybrid to mkisofs.\n"
	         "You can,of course,continue to use mkhybrid.\n"
	         "Just answer no to this question in this case.\n",
	       configupdate_to2);
	update(3,
	       "This update fixes a bug in the mp3 client call\n"
	       "which made gnometoaster record non-cd-quality\n"
	       "mp3 files with 2x or 4x the speed of the original.\n"
	       "(modifies filetype registry's mp3 entry).\n\n"
	       "Also,El Torito bootable support requires your mkisofs\n"
	       "calls to be modified.\n",	       
	       configupdate_to3);
     }
   else
     dialog_ok("You're running Gnometoaster for the first time.\n"
	       "All Preferences have been set to default values.\n"
	       "Make sure you change all settings to match your system!");
   
   /* version upgrade complete. set new config file version */
   varman_setvar_value(global_defs,"configfile_version",CONFIG_VERSION);
};
