/* implements cdrom drives as source for track streams */

#include <gtk/gtk.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>

#include "main.h"
#include "cdsource.h"
#include "datatrack.h"
#include "audiotrack.h"
#include "streams.h"
#include "preferences.h"
#include "varman.h"
#include "varmanwidgets.h"
#include "tracks.h"
#include "cddrives.h"
#include "helpings.h"
#include "trackdoubleclick.h"

cdsource_cdinfo *cdsource_cdinfo_create(cddrives_cdinfo *cddinfo)
{
	cdsource_cdinfo *info;
	
	info=(cdsource_cdinfo*)malloc(sizeof(cdsource_cdinfo));
	
	info->driveinfo=cddinfo;
	info->widget=NULL;
	info->listinfo=NULL;

	return info;
}
;

void cdsource_tracklist_create(cdsource_cdinfo*info) /* create the tracklist widget for this drive */
{
	int count;	
	
	if (info->widget==NULL) // not yet displaying,one learns of his mistakes ;-)
	  {
	     info->listinfo=tracklist_info_create(NULL,1,NULL,
						  GTK_SIGNAL_FUNC(trackdoubleclick_handler));
#ifdef DEBUG
	     printf ("displaying %i tracks...\n",info->driveinfo->tracks);
#endif
	     for (count=0;count<info->driveinfo->tracks;count++)	       
	       tracklist_addtrack(info->listinfo,
				  info->driveinfo->track[count]);
	     
	     /* I don't want to change all the functions relying on this 
	      * struct entry */
	     info->widget=info->listinfo->widget;

	  };
}
;

void cdsource_tracklist_destroy(cdsource_cdinfo*info) // destroy a tracklist
{
	if (info->widget!=NULL)
	  {
	     tracklist_info_destroy(info->listinfo);
	     info->widget=NULL;
	     info->listinfo=NULL;
	  }
	;
}
;

GtkTree *cdsource_cdtree(GtkSignalFunc selectcd,
			 GtkSignalFunc unselectcd)
{
	GtkTree *tree;
	GtkWidget *device;
	cdsource_cdinfo *info;
	int x;
	
	tree=GTK_TREE(gtk_tree_new());
	
	for (x=0;x<cddrives_drives.drivecount;x++)
	  {		  		  
		  device=gtk_tree_item_new_with_label((char*)&cddrives_drives.drive[x]->device);
		  info=cdsource_cdinfo_create(cddrives_drives.drive[x]);
		  gtk_signal_connect(GTK_OBJECT(device),
				     "select",
				     selectcd,
				     info);
		  gtk_signal_connect(GTK_OBJECT(device),
				     "deselect",
				     unselectcd,
				     info);
		  gtk_tree_append(GTK_TREE(tree),device);
		  gtk_widget_show(device);
		  
	  };
	gtk_widget_show(GTK_WIDGET(tree));
	return tree;
}
;
	
	
	
	
