/*
** Copyright (C) 10 Feb 1999 Jonas Munsin <jmunsin@iki.fi>
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
** 
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software 
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include <gtk/gtk.h>
#include <sys/wait.h>

#include "locks.h"
#include "vector_commands.h"
#include "common_gtk.h"
#include "mainwindow.h"
#include "contractions.h"
#include "read_image.h"

static int running = FALSE;

void wait_pids(void) {
	/* If these waitpids are called in the wrong order, deadlocks might arise. */
	if (cdr != 0) {
		waitpid(cdr, NULL, 0);
		cdr = 0;
	}
	if (iso != 0) {
		waitpid(iso, NULL, 0);
		iso = 0;
	}

	if (cd_file_child != 0) {
		waitpid(cd_file_child, NULL, 0);
		cd_file_child = 0;
	}
}

/* simple locks */
void not_running(void) {
	running = FALSE;

	wait_pids();

	mainwindow_enable_tabs();
}

/* checks if it's ok to fork off a new external command */
int is_running(void) {
	if (running) {
		g_warning("Something is already running!");
		return TRUE;
	} else {
		running = TRUE;
		return  FALSE;
		/* unregistrate signals? */
	}
}

/* return running - says is something still is running, should for example
 * be checked before exiting gcombust */
int check_if_running(void) {
	return running;
}

