#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>

#include "npnews.h"

int NP_News::get_folder_requests()
{
   if ( get_folder_requests_list())
      return 1;
         
   if ( !total_requests )
   {
      destroy_requests_list();
      return 0;
   }

   NP_File spool, read;

   char buffer[ 1024 ];
   snprintf( buffer, sizeof buffer, "%s/.peruser_spool/%s-%s", home,
         address, group );

   if ( spool.opena( buffer ))
   {
      destroy_requests_list();
      snprintf( error_message, sizeof error_message, "NP_News: "
            "get_folder_requests(): %s", spool.get_error() );
      return 1;
   }

   strcat( buffer, ":read" );
   if ( read.opena( buffer ))
   {
      destroy_requests_list();
      snprintf( error_message, sizeof error_message, "NP_News: "
            "get_folder_requests(): %s", read.get_error());
      return 1;
   }

   NP_File newsrc;
   snprintf( buffer, sizeof buffer, "%s/.peruser4-newsrc", home );
   if ( newsrc.openr( buffer ))
   {
      destroy_requests_list();
      snprintf( error_message, sizeof error_message, "NP_News: "
            "get_folder_requests(): %s", newsrc.get_error());
      return 1;
   }

   int servers = 0;

   char *line;
   while(( line = newsrc.get_string()) != NULL )
      if ( !isspace( *line ))
         ++servers;

   char **server_list = ( char **)calloc( servers, sizeof *server_list );
   if ( server_list == NULL )
   {
      perror( "calloc" );
      exit( 1 );
   }

   char **serv_p = server_list;
   newsrc.seek( 0, SEEK_SET );
   while(( line = newsrc.get_string()) != NULL )
      if ( !isspace( *line ))
      {
         strtok( line, "\n" );
         *serv_p = strdup( line );
         if ( *serv_p == NULL )
         {
            perror( "strdup" );
            exit( 1 );
         }

         ++serv_p;
      }

   newsrc.close();
   if ( !servers )
      return 1;

   char *old_group = "";

   serv_p = server_list;

   for( int s = 0; s < servers; ++s )
   {
      if ( fd >= 0 )
         disconnect();

      if ( do_connect( *serv_p, "r" ))
         return 1;

      np_requests_list_t *pointer = requests_list;
      for( int i = 0; i < total_requests; ++i )
      {
         if ( !strcmp( *serv_p, pointer->server ))
         {
            if ( strcmp( old_group, pointer->group ))
            {
               if ( change_group( pointer->group ) == NULL )
                  continue;

               old_group = pointer->group;
            }

            snprintf( buffer, sizeof buffer, "article %s\r\n",
                  pointer->request );

            if ( put_string( buffer ))
               continue;

            if ( get_string( buffer, sizeof buffer ))
               continue;

            if ( check_response( buffer ))
               continue;

            pointer->found = 1;

            do
            {
               if ( get_string( buffer, sizeof buffer ))
                  break;

               if ( spool.put_string( buffer ))
                  break;
            }
            while( strncmp( buffer, ".\r\n", 3 ));

            read.put_string( "u\n" );

            ++total_messages_transferred;
         }

         ++pointer;
      }

      free( *serv_p );
      ++serv_p;
   }

   free( server_list );

   disconnect();

   spool.close();
   read.close();

   remove_headers();

   destroy_requests_list();

   return 0;
}
