#include <string.h>

#include "nptext.h"

void show_header_button_callback( GtkWidget *widget, gpointer data )
{
   NP_Text *text = ( NP_Text *)data;

   if ( text->header_shown == -2 )
   {
      text->show_message( "There is no message currently loaded." );
      return;
   }

   if ( text->header_shown < 0 )
   {
      text->show_message( "Message is a header-only news article. The "
                          "header is already shown." );

      while( text->message_window != NULL )
         while( gtk_events_pending() )
            gtk_main_iteration();
      
      return;
   }

   int len;
   char *pointer;
   
   if ( text->header_shown ^= 1 )
   {
      pointer = text->text;
      len = strlen( text->text ) + 1;
   }
   else
   {
      pointer = strstr( text->text, "\r\n\r\n" );
      if ( pointer != NULL )
      {
         pointer += 4;
         len = strlen( pointer ) + 1;
      }
      else
      {
         pointer = text->text;
         len = strlen( text->text ) + 1;
      }
   }

   int old_len = gtk_text_get_length( GTK_TEXT( text->text_widget ));
   gtk_text_freeze( GTK_TEXT( text->text_widget ));
   gtk_text_set_point( GTK_TEXT( text->text_widget ), 0 );
   gtk_text_forward_delete( GTK_TEXT( text->text_widget ), old_len );

   gtk_text_insert( GTK_TEXT( text->text_widget ), NULL, NULL, NULL,
                    pointer, len );
   gtk_text_thaw( GTK_TEXT( text->text_widget ));

   return;
}
