#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <errno.h>

#include "npthreads.h"

void NP_Threads::dup_line( char **line, char *source, int skip )
{
   char *beginning = source + skip + strspn( source + skip, " \t" );
   if ( strchr( beginning, '\r' ) != NULL )
      strtok( beginning, "\r\n" );

   if (( *line = strdup( beginning )) == NULL )
   {
      perror( "strdup" );
      exit( 1 );
   }

   return;
}

int NP_Threads::make_refs( np_ref_node_t **references,
                           char *source, NP_File& spool )
{
   char *temp;
   if (( temp = strdup( source )) == NULL )
   {
      perror( "strdup" );
      exit( 1 );
   }

   long spool_position = spool.tell();
   if ( spool_position < 0 )
   {
      snprintf( error_message, sizeof error_message,
                "NP_Threads: make_refs(): %s", spool.get_error());
      return 1;
   }

   int more = 0;

   for( ; ; )
   {
      char *line;
      if (( line = spool.get_string()) == NULL )
      {
         strcpy( error_message, "NP_Threads: "
                 "make_refs(): premature end of spool." );
         return 1;
      }

      if ( isspace( *line ))
      {
         if (( temp = ( char *)realloc( temp, strlen( temp ) +
                                        strlen( line ) + 1 )) == NULL )
         {
            perror( "realloc" );
            exit( 1 );
         }

         more = 1;
         continue;
      }
      else
         break;
   }

   if ( !more )
      if ( spool.seek( spool_position, SEEK_SET ))
      {
         snprintf( error_message, sizeof error_message,
                   "NP_Threads: make_refs(): %s", spool.get_error());
         return 1;
      }

   make_ref_list( references, temp );

   return 0;
}

void NP_Threads::make_ref_list( np_ref_node_t **references, char *raw )
{
   np_ref_node_t *pointer = NULL, *temp = NULL;

   for( char *ref_pointer = strtok( raw + 11, " \t\r\n" );
        ref_pointer != NULL;
        ref_pointer = strtok( NULL, " \t\r\n" ))
   {
      if ( pointer == NULL )
      {
         if (( pointer = ( np_ref_node_t *)malloc( sizeof *pointer )) == NULL )
         {
            perror( "malloc" );
            exit( 1 );
         }

         pointer->prev = NULL;
         *references = pointer;
      }
      else
      {
         if (( pointer->next = ( np_ref_node_t *)malloc( sizeof *pointer ))
             == NULL )
         {
            perror( "malloc" );
            exit( 1 );
         }

         temp = pointer;
         pointer = pointer->next;
         pointer->prev = temp;
      }
      
      if (( pointer->reference = strdup( ref_pointer )) == NULL )
      {
         perror( "strdup" );
         exit( 1 );
      }
   }

   pointer->next = NULL;

   return;
}

int NP_Threads::load( char *server, char *group, 
                      int hide_seen, int hide_headers )
{
   char spool_path[ 1024 ];
   snprintf( spool_path, sizeof spool_path, "%s/.peruser_spool/%s-%s",
             home, server, group );
   NP_File spool;
   if ( spool.openr( spool_path ))
   {
      if ( errno == ENOENT )
         return 2;
      
      snprintf( error_message, sizeof error_message, "NP_Threads: load(): "
                "%s", spool.get_error());
      return 1;
   }

   char read_path[ 1024 ];
   snprintf( read_path, sizeof read_path, "%s:read", spool_path );
   NP_File read;
   if ( read.openr( read_path ))
      if ( errno != ENOENT )
      {
         snprintf( error_message, sizeof error_message, "NP_Threads: load(): "
                   "%s", read.get_error());
         return 1;
      }

   char requests_path[ 1024 ];
   snprintf( requests_path, sizeof requests_path, "%s:requests", spool_path );
   NP_File requests;
   if ( requests.openr( requests_path ))
      if ( errno != ENOENT )
      {         
         snprintf( error_message, sizeof error_message, "NP_Threads: load(): "
                   "%s", requests.get_error());
         return 1;
      }

   char *line;

   if ( spool.seek( 0, SEEK_SET ))
   {
      snprintf( error_message, sizeof error_message, "NP_Threads: load(): "
                "%s", spool.get_error());
      return 1;
   }

   long offset = 0, old_offset;
   int position = 0;
   
   np_thread_node_t *nodes = NULL;

   for( ; ; )
   {
      old_offset = offset;

      offset = spool.tell();
      if ( offset < 0 )
      {
         snprintf( error_message, sizeof error_message, "NP_Threads: "
                   "load(): %s", spool.get_error());
         clear();
         return 1;
      }

      if (( line = spool.get_string()) == NULL )
         break;

      char *isread;
      isread = read.get_string();

      if (( hide_headers && *line == '@' ) || ( hide_seen && *isread == 'r' ))
      {
         while(( line = spool.get_string()) != NULL )
            if ( !strncmp( line, ".\r\n", 3 ))
               break;

         continue;
      }

      if ( nodes == NULL )
      {
         if (( nodes = ( np_thread_node_t *)malloc( sizeof *nodes )) == NULL )
         {
            perror( "malloc" );
            exit( 1 );
         }

         nodes->prev = nodes->spool_prev = NULL;
         nodes->offset = offset;
         threads = nodes;
      }
      else
      {
         if (( nodes->next = ( np_thread_node_t *)malloc( sizeof *nodes ))
             == NULL )
         {
            perror( "malloc" );
            exit( 1 );
         }

         nodes->spool_next = nodes->next;
         nodes->next->prev = nodes->next->spool_prev = nodes;
         nodes->size = offset - old_offset;
         nodes = nodes->next;
         nodes->offset = offset;
      }

      nodes->child_next = nodes->child_prev = nodes->child_head =
         nodes->child_tail = nodes->parent = NULL;

      nodes->child_count = nodes->descendents = nodes->unseen_descendents =
         nodes->requested_descendents = nodes->header_descendents =
         nodes->gap = 0;

      nodes->ordinal = position++;

      nodes->references = NULL;

      if ( isread == NULL )
         nodes->is_unseen = 0;
      else
         nodes->is_unseen = (( *isread == 'u' ) ? 1 : 0 );

      int passed_header = 0, subject_found = 0, date_found = 0,
         from_found = 0, message_id_found = 0, references_found = 0,
         server_found = 0, group_found = 0;

      nodes->is_article = 1;
      nodes->is_child = 0;
      nodes->server = nodes->group = NULL;

      int first_pass = 1;

      do
      {
         if ( !first_pass )
            if (( line = spool.get_string()) == NULL )
            {
               snprintf( error_message, sizeof error_message, "NP_Threads: "
                         "load(): premature end of spool: %s", spool_path );
               clear();
               return 1;
            }

         first_pass = 0;

         if ( !strncmp( line, "\r\n", 2 ))
         {
            passed_header = 1;
            continue;
         }

         if ( !passed_header )
         {
            if ( *line == '@' )
            {
               nodes->is_article = 0;
               continue;
            }
 
            if ( !server_found && !strncmp( line, "X-Peruser-Server: ", 18 ))
            {
               dup_line( &nodes->server, line, 18 );
               server_found = 1;
               continue;
            }

            if ( !group_found && !strncmp( line, "X-Peruser-Newsgroup: ", 21 ))
            {
               dup_line( &nodes->group, line, 21 );
               group_found = 1;
               continue;
            }

            if ( !from_found && !strncasecmp( line, "From:", 5 ))
            {
               dup_line( &nodes->from, line, 5 );
               from_found = 1;
               continue;
            }

            if ( !subject_found && !strncasecmp( line, "Subject:", 8 ))
            {
               dup_line( &nodes->subject, line, 8 );
               subject_found = 1;
               continue;
            }

            if ( !date_found && !strncasecmp( line, "Date:", 5 ))
            {
               dup_line( &nodes->date, line, 5 );
               date_found = 1;
               continue;
            }

            if ( !message_id_found && !strncasecmp( line, "Message-ID:", 11 ))
            {
               dup_line( &nodes->message_id, line, 11 );
               message_id_found = 1;

               if ( !requests.is_open )
               {
                  nodes->is_requested = 0;
                  continue;
               }

               if ( requests.seek( 0, SEEK_SET ))
               {
                  snprintf( error_message, sizeof error_message,
                            "NP_Threads: load(): %s", requests.get_error());
                  clear();
                  return 1;
               }

               char *request_line;
               while(( request_line = requests.get_string()) != NULL )
               {
                  if ( strtok( request_line, ":\n" ) == NULL )
                     break;

                  if ( !strcmp( request_line, nodes->message_id ))
                     break;
               }

               nodes->is_requested = (( request_line == NULL ) ? 0 : 1 );
               continue;
            }
            
            if ( !references_found && !strncasecmp( line, "References:", 11 ))
            {
               make_refs( &nodes->references, line, spool );
               references_found = 1;
            }
         }
      }
      while( strncmp( line, ".\r\n", 3 ));

      if ( !server_found )
         nodes->server = NULL;

      if ( !group_found ) 
         nodes->group = NULL;

      if ( !subject_found )
         dup_line( &nodes->subject, "Subject: (article no subject)", 8 );

      if ( !date_found )
         dup_line( &nodes->date, "Date: (article has no date)", 5 );

      if( !message_id_found )
         dup_line( &nodes->message_id, 
                   "Message-ID: <dummy@nowhere> (article has no message-id)", 
                   11 );
   }

   total = unseen = headers = requested = 0;

   if ( threads != NULL )
   {
      nodes->size = offset - old_offset;
      nodes->next = nodes->spool_next = NULL;
      
      for( nodes = threads; nodes != NULL; nodes = nodes->next )
      {
         ++total;

         unseen += nodes->is_unseen;
         headers += (( nodes->is_article ) ? 0 : 1 );
         requested += nodes->is_requested;
      }
   }

   spool_beginning = threads;

   return 0;
}
